
include 'basic.h';
include 'utils.h';
include 'stat.h';

export export type trace := *str;

unpack[x: *str] := 
if size(x) <= 1
then {}
else ins(<<head(x),head(tail(x))>>,unpack(tail(x)))
fi
 : $(str >< str);

f[x: T -> (T -> bool)] := 
if x = {}
then {}
else rng[y:set(pi2(pick(x)))|<<pi1(pick(x)),y>>]  union f(frest(x))
fi
 : $(T >< T);

select[x: str, t: $str, r: real] := 
if x elt t
then 2.0-abs(r-(rank(x,t)/(size(t)+1.)))
else 3.0
fi
 : real;

rank[x: str, t: $str] := 
if t = {} 
then 0.0
else if pick(t) = x
then 1.0
else 1.0 + rank(x,rest(t))
fi fi
 : real;

powerset[x: $T] := hpowerset(x,{})
 : $($T);

hpowerset[x: $T, y: $T] := 
if x = {}
then {y}
else hpowerset(rest(x),y) union hpowerset(rest(x),ins(pick(x),y))
fi
 : $($T);

clean[x: $($T >< $T)] := hclean(x,{})
 : $($T >< $T);

hclean[x: $($T >< $T), y: $($T >< $T)] := 
if x = {}
then y
else
if any[z:rest(x) union y | subset(pi1(pick(x)),pi1(z)) and subset(pi2(pick(x)),pi2(z))]
then hclean(rest(x),y)
else hclean(rest(x),ins(pick(x),y))
fi
fi
 : $($T >< $T);

places[x: $($str >< $str)] := rng[y:x|fplace(y)] union {'i_w','o_w'}
 : $str;

fplace[x: $str >< $str] := 'P_' cat setstr(pi1(x)) cat '->'  cat setstr(pi2(x))
 : str;

setstr[x: $str] := 
if x = {}
then ''
else 
if rest(x) = {}
then pick(x) 
else pick(x) cat ',' cat setstr(rest(x))
fi
fi
 : str;

arcs[Ti: $str, To: $str, x: $($str >< $str)] := 
rng[y:Ti|<<'i_w',y>>] union
rng[y:To|<<y,'o_w'>>] union
union(rng[y:x| rng[z:pi2(y) | <<fplace(y),z>>]]) union
union(rng[y:x| rng[z:pi1(y) | <<z,fplace(y)>>]])
 : $(str >< str);

make_list[x: num -> str] := 
if x = {}
then <| |>
else x.min(dom(x)) ins make_list([y:min(dom(x)) del dom(x)|x.y])
fi
 : *str;

proc tak[
    in tik: num, 
    out tik: num, 
    out gt: num, 
    store switch: bool
    | pre switch]
:= 
tik <- tik + 1 delay 1.0,
gt <- tik
;

proc start_case[
    in case: num, 
    out i: num, 
    store runs: num -> *str]
:= 
i <- case,
runs <- ins(<<case,<||>>>,runs)
;

proc end_case[
    in o: num, 
    out case_trace: trace, 
    store runs: num -> *str]
:= 
case_trace  <- runs.o,
runs <- [x:del(o,dom(runs))|runs.x]
;

proc analyze_single_case[
    in case_trace: trace, 
    store Tw: $str, 
    store Ti: $str, 
    store To: $str, 
    store rel: $(str >< str)]
:= 
Tw <- set(case_trace) union Tw,
Ti <- ins(head(case_trace),Ti),
To <- ins(head(reverse(case_trace)),To),
rel <- rel union unpack(case_trace)
;

proc step1[
    in calculate: bool, 
    out s1: bool, 
    store rel: $(str >< str), 
    store arrow: $(str >< str), 
    store par: $(str >< str), 
    store choice: $(str >< str), 
    store Tw: $str]
:= 
s1 <- calculate,
arrow <- f([x:Tw | [y:Tw | (<<x,y>> elt rel) and not (<<y,x>> elt rel)]]),
par <- f([x:Tw|[y:Tw | (<<x,y>> elt rel) and (<<y,x>> elt rel)]]),
choice <- f([x:Tw | [y:Tw | not(<<x,y>> elt rel) and not(<<y,x>> elt rel)]])
;

proc step2[
    in s1: bool, 
    out s2: $($(str)), 
    store choice: $(str >< str), 
    store Tw: $str]
:= 
s2 <- set[x:powerset(Tw)| (x!= {}) and all[y:x|all[z:x| <<y,z>> elt choice]]]
;

proc step3[
    in s2: $($(str)), 
    out s3: $(($str) >< ($str)), 
    store arrow: $(str >< str)]
:= 
s3 <- f[x:s2|[y:s2| all[a:x| all[b:y|<<a,b>> elt arrow]]]]
;

proc step4[
    in s3: $(($str) >< ($str)), 
    out s4: $(($str) >< ($str))]
:= 
s4 <- clean(s3)
;

proc step5[
    in s4: $(($str) >< ($str)), 
    out output: [Pw: $str, Tw: $str, Fw: $(str >< str)], 
    store Tw: $str, 
    store Ti: $str, 
    store To: $str]
:= 
output <- [Pw:places(s4),Tw:Tw,Fw:arcs(Ti,To,s4)]
;

proc transfer[
    in i: T, 
    out o: T]
:= 
o <- i
;

proc unpack[
    in i: $str, 
    out i: $str, 
    out o: str]
:= 
if i !={}
then 
i <- rest(i),
o <- pick(i)
fi
;

proc make_list[
    in i: str, 
    out o: trace]
:= 
o<-make_list(parse(i,','))
;

export sys main
:= 
  token_generator(out case, store switch),
--GI  [ID:1,KIND:0,SYMBNR:0,X:21,Y:18,XSIZE:8,YSIZE:8,COLOR:71180,LINES:{[ID:1,C
--GICOLOR:12,TOid:4]}] [ID:2,KIND:-2,XPERC:50,YPERC:120,NAME:[ID:3,NAME:'token_g
--GICenerator'],PARENT:{1}]

  channel case : num,
--GI  [ID:4,KIND:1,SYMBNR:1,X:36,Y:20,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:4,C
--GICOLOR:12,TOid:7]}] [ID:5,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:6,NAME:'case'],
--GICPARENT:{4}]

  process(in case, out case_trace),
--GI  [ID:7,KIND:0,SYMBNR:0,X:48,Y:18,XSIZE:8,YSIZE:8,COLOR:71180,LINES:{[ID:7,C
--GICOLOR:12,TOid:10]}] [ID:8,KIND:-2,XPERC:50,YPERC:120,NAME:[ID:9,NAME:'proces
--GICs'],PARENT:{7}]

  channel case_trace : trace,
--GI  [ID:10,KIND:1,SYMBNR:1,X:49,Y:5,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:10,
--GICCOLOR:12,TOid:13]}] [ID:11,KIND:-2,XPERC:45,YPERC:-65,NAME:[ID:12,NAME:'cas
--GICe_trace'],PARENT:{10}]

  analyze(in case_trace),
--GI  [ID:13,KIND:0,SYMBNR:0,X:70,Y:3,XSIZE:8,YSIZE:8,COLOR:71180] [ID:14,KIND:-
--GIC2,XPERC:50,YPERC:120,NAME:[ID:15,NAME:'analyze'],PARENT:{13}]

  store switch : bool in user init false,
--GI  [ID:16,KIND:2,SYMBNR:118,X:7,Y:20,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:1
--GIC6,COLOR:12,TOid:1]}] [ID:17,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:18,NAME:'sw
--GICitch'],PARENT:{16}]

  input_workflow_log(out case_trace)
--GI  [ID:19,KIND:0,SYMBNR:0,X:20,Y:3,XSIZE:8,YSIZE:8,COLOR:71180,LINES:{[ID:19,
--GICCOLOR:12,TOid:10]}] [ID:20,KIND:-2,XPERC:50,YPERC:120,NAME:[ID:21,NAME:'inp
--GICut_workflow_log'],PARENT:{19}]
;

sys token_generator[
    out tg: num, 
    store switch: bool]
--GIH [ID:1,KIND:4,SYMBNR:4,X:52,Y:21,XSIZE:8,YSIZE:8,COLOR:69388] [ID:2,KIND:-2
--GIC,XPERC:50,YPERC:145,NAME:[ID:3,NAME:'tg'],PARENT:{1}]
--GIH [ID:4,KIND:5,SYMBNR:5,X:6,Y:6,XSIZE:8,YSIZE:8,COLOR:65292,LINES:{[ID:4,COL
--GICOR:12,TOid:7]}] [ID:5,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:6,NAME:'switch'],
--GICPARENT:{4}]
:= 
  tak(in tik, out tik, out tg, store switch),
--GI  [ID:7,KIND:6,SYMBNR:122,X:21,Y:19,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:7
--GIC,COLOR:12,TOid:1],[ID:7,COLOR:12,TOid:10]}] [ID:8,KIND:-2,XPERC:50,YPERC:12
--GIC2,NAME:[ID:9,NAME:'tak'],PARENT:{7}]

  channel tik : num init 1
--GI  [ID:10,KIND:1,SYMBNR:1,X:15,Y:7,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:10,
--GICCOLOR:12,TOid:7]}] [ID:11,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:12,NAME:'tik'
--GIC],PARENT:{10}]
;

sys process[
    in case: num, 
    out case_trace: trace]
--GIH [ID:1,KIND:3,SYMBNR:3,X:2,Y:62,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:1,CO
--GICLOR:12,TOid:7]}] [ID:2,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:3,NAME:'case'],P
--GICARENT:{1}]
--GIH [ID:4,KIND:4,SYMBNR:4,X:152,Y:59,XSIZE:8,YSIZE:8,COLOR:69388] [ID:5,KIND:-
--GIC2,XPERC:50,YPERC:145,NAME:[ID:6,NAME:'case_trace'],PARENT:{4}]
:= 
  start_case(in case, out i, store runs),
--GI  [ID:7,KIND:6,SYMBNR:122,X:18,Y:59,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:7
--GIC,COLOR:12,TOid:13]}] [ID:8,KIND:-2,XPERC:50,YPERC:120,NAME:[ID:9,NAME:'star
--GICt_case'],PARENT:{7}]

  store runs : num -> *str in global init {},
--GI  [ID:10,KIND:2,SYMBNR:118,X:64,Y:62,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC10,COLOR:12,TOid:16],[ID:10,COLOR:12,TOid:7]}] [ID:11,KIND:-2,XPERC:50,YPER
--GICC:145,NAME:[ID:12,NAME:'runs'],PARENT:{10}]

  channel i : num,
--GI  [ID:13,KIND:1,SYMBNR:1,X:29,Y:25,XSIZE:7,YSIZE:8,COLOR:69388,LINES:{[ID:13
--GIC,COLOR:12,TOid:28]}] [ID:14,KIND:-2,XPERC:50,YPERC:144,NAME:[ID:15,NAME:'i'
--GIC],PARENT:{13}]

  end_case(in o, out case_trace, store runs),
--GI  [ID:16,KIND:6,SYMBNR:122,X:136,Y:57,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID
--GIC:16,COLOR:12,TOid:4]}] [ID:17,KIND:-2,XPERC:50,YPERC:120,NAME:[ID:18,NAME:'
--GICend_case'],PARENT:{16}]

  channel o : num,
--GI  [ID:19,KIND:1,SYMBNR:1,X:119,Y:23,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:1
--GIC9,COLOR:12,TOid:16]}] [ID:20,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:21,NAME:'o
--GIC'],PARENT:{19}]

  channel p2 : num,
--GI  [ID:22,KIND:1,SYMBNR:1,X:54,Y:25,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:22
--GIC,COLOR:12,TOid:31]}] [ID:23,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:24,NAME:'p2
--GIC'],PARENT:{22}]

  d:task11(in p3, out o, val 'd'),
--GI  [ID:25,KIND:0,SYMBNR:0,X:84,Y:24,XSIZE:8,YSIZE:8,COLOR:71180,LINES:{[ID:25
--GIC,COLOR:12,TOid:19]}] [ID:26,KIND:-2,XPERC:50,YPERC:122,NAME:[ID:27,NAME:'d'
--GIC],PARENT:{25}]

  a:task11(in i, out p2, val 'a'),
--GI  [ID:28,KIND:0,SYMBNR:0,X:41,Y:23,XSIZE:8,YSIZE:8,COLOR:71180,LINES:{[ID:28
--GIC,COLOR:12,TOid:22]}] [ID:29,KIND:-2,XPERC:50,YPERC:122,NAME:[ID:30,NAME:'a'
--GIC],PARENT:{28}]

  b:task11(in p2, out p3, val 'b'),
--GI  [ID:31,KIND:0,SYMBNR:0,X:59,Y:6,XSIZE:8,YSIZE:8,COLOR:71180,LINES:{[ID:31,
--GICCOLOR:12,TOid:34]}] [ID:32,KIND:-2,XPERC:50,YPERC:120,NAME:[ID:33,NAME:'b']
--GIC,PARENT:{31}]

  channel p3 : num,
--GI  [ID:34,KIND:1,SYMBNR:1,X:71,Y:25,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:34
--GIC,COLOR:12,TOid:37],[ID:34,COLOR:12,TOid:25]}] [ID:35,KIND:-2,XPERC:50,YPERC
--GIC:145,NAME:[ID:36,NAME:'p3'],PARENT:{34}]

  c:task11(in p3, out p2, val 'c')
--GI  [ID:37,KIND:0,SYMBNR:0,X:58,Y:40,XSIZE:8,YSIZE:8,COLOR:71180,LINES:{[ID:37
--GIC,COLOR:12,TOid:22]}] [ID:38,KIND:-2,XPERC:50,YPERC:120,NAME:[ID:39,NAME:'c'
--GIC],PARENT:{37}]
;

sys analyze[
    in case_trace: trace]
--GIH [ID:1,KIND:3,SYMBNR:3,X:5,Y:48,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:1,CO
--GICLOR:12,TOid:16]}] [ID:2,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:3,NAME:'case_tr
--GICace'],PARENT:{1}]
:= 
  store Tw : $str init {},
--GI  [ID:4,KIND:2,SYMBNR:118,X:47,Y:30,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:4
--GIC,COLOR:12,TOid:55],[ID:4,COLOR:12,TOid:37],[ID:4,COLOR:12,TOid:19],[ID:4,CO
--GICLOR:12,TOid:16]}] [ID:5,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:6,NAME:'Tw'],PA
--GICRENT:{4}]

  store Ti : $str init {},
--GI  [ID:7,KIND:2,SYMBNR:118,X:107,Y:31,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC7,COLOR:12,TOid:55],[ID:7,COLOR:12,TOid:16]}] [ID:8,KIND:-2,XPERC:50,YPERC:
--GIC145,NAME:[ID:9,NAME:'Ti'],PARENT:{7}]

  store To : $str init {},
--GI  [ID:10,KIND:2,SYMBNR:118,X:111,Y:31,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID
--GIC:10,COLOR:12,TOid:55],[ID:10,COLOR:12,TOid:16]}] [ID:11,KIND:-2,XPERC:50,YP
--GICERC:145,NAME:[ID:12,NAME:'To'],PARENT:{10}]

  store rel : $(str >< str) in user init {},
--GI  [ID:13,KIND:2,SYMBNR:118,X:18,Y:30,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC13,COLOR:12,TOid:19],[ID:13,COLOR:12,TOid:16]}] [ID:14,KIND:-2,XPERC:50,YPE
--GICRC:145,NAME:[ID:15,NAME:'rel'],PARENT:{13}]

  analyze_single_case(in case_trace, store Tw, store Ti, store To, store rel),
--GI  [ID:16,KIND:6,SYMBNR:122,X:19,Y:46,XSIZE:8,YSIZE:8,COLOR:67084] [ID:17,KIN
--GICD:-2,XPERC:50,YPERC:120,NAME:[ID:18,NAME:'analyze_single_case'],PARENT:{16}
--GIC]

  step1(in calculate, out s1, store rel, store arrow, store par, store choice, store Tw),
--GI  [ID:19,KIND:6,SYMBNR:122,X:20,Y:3,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:1
--GIC9,COLOR:12,TOid:34]}] [ID:20,KIND:-2,XPERC:55,YPERC:-20,NAME:[ID:21,NAME:'s
--GICtep1'],PARENT:{19}]

  channel calculate : bool in user,
--GI  [ID:22,KIND:1,SYMBNR:1,X:4,Y:6,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:22,C
--GICOLOR:12,TOid:19]}] [ID:23,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:24,NAME:'calc
--GICulate'],PARENT:{22}]

  store par : $(str >< str) in user init {},
--GI  [ID:25,KIND:2,SYMBNR:118,X:23,Y:30,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC25,COLOR:12,TOid:19]}] [ID:26,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:27,NAME:'
--GICpar'],PARENT:{25}]

  store choice : $(str >< str) in user init {},
--GI  [ID:28,KIND:2,SYMBNR:118,X:35,Y:30,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC28,COLOR:12,TOid:37],[ID:28,COLOR:12,TOid:19]}] [ID:29,KIND:-2,XPERC:50,YPE
--GICRC:145,NAME:[ID:30,NAME:'choice'],PARENT:{28}]

  store arrow : $(str >< str) in user init {},
--GI  [ID:31,KIND:2,SYMBNR:118,X:68,Y:30,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC31,COLOR:12,TOid:43],[ID:31,COLOR:12,TOid:19]}] [ID:32,KIND:-2,XPERC:50,YPE
--GICRC:145,NAME:[ID:33,NAME:'arrow'],PARENT:{31}]

  channel s1 : bool,
--GI  [ID:34,KIND:1,SYMBNR:1,X:35,Y:6,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:34,
--GICCOLOR:12,TOid:37]}] [ID:35,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:36,NAME:'s1'
--GIC],PARENT:{34}]

  step2(in s1, out s2, store choice, store Tw),
--GI  [ID:37,KIND:6,SYMBNR:122,X:44,Y:4,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:3
--GIC7,COLOR:12,TOid:40]}] [ID:38,KIND:-2,XPERC:52,YPERC:-17,NAME:[ID:39,NAME:'s
--GICtep2'],PARENT:{37}]

  channel s2 : $($(str)),
--GI  [ID:40,KIND:1,SYMBNR:1,X:57,Y:5,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:40,
--GICCOLOR:12,TOid:43]}] [ID:41,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:42,NAME:'s2'
--GIC],PARENT:{40}]

  step3(in s2, out s3, store arrow),
--GI  [ID:43,KIND:6,SYMBNR:122,X:65,Y:4,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:4
--GIC3,COLOR:12,TOid:46]}] [ID:44,KIND:-2,XPERC:50,YPERC:-22,NAME:[ID:45,NAME:'s
--GICtep3'],PARENT:{43}]

  channel s3 : $(($str) >< ($str)),
--GI  [ID:46,KIND:1,SYMBNR:1,X:79,Y:6,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:46,
--GICCOLOR:12,TOid:49]}] [ID:47,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:48,NAME:'s3'
--GIC],PARENT:{46}]

  step4(in s3, out s4),
--GI  [ID:49,KIND:6,SYMBNR:122,X:86,Y:4,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:4
--GIC9,COLOR:12,TOid:52]}] [ID:50,KIND:-2,XPERC:50,YPERC:-17,NAME:[ID:51,NAME:'s
--GICtep4'],PARENT:{49}]

  channel s4 : $(($str) >< ($str)),
--GI  [ID:52,KIND:1,SYMBNR:1,X:99,Y:6,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:52,
--GICCOLOR:12,TOid:55]}] [ID:53,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:54,NAME:'s4'
--GIC],PARENT:{52}]

  step5(in s4, out output, store Tw, store Ti, store To),
--GI  [ID:55,KIND:6,SYMBNR:122,X:107,Y:4,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:
--GIC55,COLOR:12,TOid:58]}] [ID:56,KIND:-2,XPERC:50,YPERC:-20,NAME:[ID:57,NAME:'
--GICstep5'],PARENT:{55}]

  channel output : [Pw: $str, Tw: $str, Fw: $(str >< str)] in user
--GI  [ID:58,KIND:1,SYMBNR:1,X:121,Y:49,XSIZE:8,YSIZE:8,COLOR:69388] [ID:59,KIND
--GIC:-2,XPERC:50,YPERC:145,NAME:[ID:60,NAME:'output'],PARENT:{58}]
;

export sys task11[
    in i1: num, 
    out o1: num, 
    val self: str]
--GIH [ID:1,KIND:3,SYMBNR:3,X:13,Y:18,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:1,C
--GICOLOR:12,TOid:7]}] [ID:2,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:3,NAME:'i1'],PA
--GICRENT:{1}]
--GIH [ID:4,KIND:4,SYMBNR:4,X:94,Y:19,XSIZE:8,YSIZE:8,COLOR:69388] [ID:5,KIND:-2
--GIC,XPERC:50,YPERC:145,NAME:[ID:6,NAME:'o1'],PARENT:{4}]
:= 
  ptask(in i1, out o1, store runs, store random, store tasks, val self),
--GI  [ID:7,KIND:6,SYMBNR:122,X:48,Y:15,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:7
--GIC,COLOR:12,TOid:4]}] [ID:8,KIND:-2,XPERC:50,YPERC:120,NAME:[ID:9,NAME:'ptask
--GIC'],PARENT:{7}]

  store random : real in system,
--GI  [ID:10,KIND:2,SYMBNR:118,X:49,Y:35,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC10,COLOR:12,TOid:7]}] [ID:11,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:12,NAME:'r
--GICandom'],PARENT:{10}]

  store runs : num -> *str in global init {},
--GI  [ID:13,KIND:2,SYMBNR:118,X:65,Y:36,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC13,COLOR:12,TOid:7]}] [ID:14,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:15,NAME:'r
--GICuns'],PARENT:{13}]

  store tasks : $str in global init {}
--GI  [ID:16,KIND:2,SYMBNR:118,X:32,Y:34,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC16,COLOR:12,TOid:7]}] [ID:17,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:18,NAME:'t
--GICasks'],PARENT:{16}]

where
  proc ptask[
      in i: num, 
      out o: num, 
      store runs: num -> *str, 
      store random: real, 
      store tasks: $str, 
      val name: str
      | prio select(name,tasks,random)]
  := 
o <- i delay nexp(1.,random(random)),
runs <- [ c:dom(runs)| if c=i then runs.c cat <| name |> else runs.c fi],
tasks <- ins(name,tasks)
  ;

end;

export sys task12[
    in i1: num, 
    out o1: num, 
    out o2: num, 
    val self: str]
--GIH [ID:1,KIND:3,SYMBNR:3,X:13,Y:18,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:1,C
--GICOLOR:12,TOid:10]}] [ID:2,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:3,NAME:'i1'],P
--GICARENT:{1}]
--GIH [ID:4,KIND:4,SYMBNR:4,X:94,Y:19,XSIZE:8,YSIZE:8,COLOR:69388] [ID:5,KIND:-2
--GIC,XPERC:50,YPERC:145,NAME:[ID:6,NAME:'o1'],PARENT:{4}]
--GIH [ID:7,KIND:4,SYMBNR:4,X:6,Y:6,XSIZE:8,YSIZE:8,COLOR:69388] [ID:8,KIND:-2,X
--GICPERC:50,YPERC:145,NAME:[ID:9,NAME:'o2'],PARENT:{7}]
:= 
  ptask(in i1, out o1, out o2, store runs, store random, store tasks, val self),
--GI  [ID:10,KIND:6,SYMBNR:122,X:48,Y:15,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:
--GIC10,COLOR:12,TOid:7],[ID:10,COLOR:12,TOid:4]}] [ID:11,KIND:-2,XPERC:50,YPERC
--GIC:120,NAME:[ID:12,NAME:'ptask'],PARENT:{10}]

  store random : real in system,
--GI  [ID:13,KIND:2,SYMBNR:118,X:49,Y:35,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC13,COLOR:12,TOid:10]}] [ID:14,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:15,NAME:'
--GICrandom'],PARENT:{13}]

  store runs : num -> *str in global init {},
--GI  [ID:16,KIND:2,SYMBNR:118,X:65,Y:36,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC16,COLOR:12,TOid:10]}] [ID:17,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:18,NAME:'
--GICruns'],PARENT:{16}]

  store tasks : $str in global init {}
--GI  [ID:19,KIND:2,SYMBNR:118,X:32,Y:34,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC19,COLOR:12,TOid:10]}] [ID:20,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:21,NAME:'
--GICtasks'],PARENT:{19}]

where
  proc ptask[
      in i: num, 
      out o1: num, 
      out o2: num, 
      store runs: num -> *str, 
      store random: real, 
      store tasks: $str, 
      val name: str
      | prio select(name,tasks,random)]
  := 
o1 <- i delay nexp(1.,random),
o2 <- i delay nexp(1.,random(random)),
runs <- [ c:dom(runs)| if c=i then runs.c cat <| name |> else runs.c fi],
tasks <- ins(name,tasks)
  ;

end;

export sys task21[
    in i1: num, 
    in i2: num, 
    out o1: num, 
    val self: str]
--GIH [ID:1,KIND:3,SYMBNR:3,X:13,Y:18,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:1,C
--GICOLOR:12,TOid:10]}] [ID:2,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:3,NAME:'i1'],P
--GICARENT:{1}]
--GIH [ID:4,KIND:3,SYMBNR:4,X:94,Y:19,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:4,C
--GICOLOR:12,TOid:10]}] [ID:5,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:6,NAME:'i2'],P
--GICARENT:{4}]
--GIH [ID:7,KIND:4,SYMBNR:4,X:6,Y:6,XSIZE:8,YSIZE:8,COLOR:69388] [ID:8,KIND:-2,X
--GICPERC:50,YPERC:145,NAME:[ID:9,NAME:'o1'],PARENT:{7}]
:= 
  ptask(in i1, in i2, out o1, store runs, store random, store tasks, val self),
--GI  [ID:10,KIND:6,SYMBNR:122,X:48,Y:15,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:
--GIC10,COLOR:12,TOid:7]}] [ID:11,KIND:-2,XPERC:50,YPERC:120,NAME:[ID:12,NAME:'p
--GICtask'],PARENT:{10}]

  store random : real in system,
--GI  [ID:13,KIND:2,SYMBNR:118,X:49,Y:35,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC13,COLOR:12,TOid:10]}] [ID:14,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:15,NAME:'
--GICrandom'],PARENT:{13}]

  store runs : num -> *str in global init {},
--GI  [ID:16,KIND:2,SYMBNR:118,X:65,Y:36,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC16,COLOR:12,TOid:10]}] [ID:17,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:18,NAME:'
--GICruns'],PARENT:{16}]

  store tasks : $str in global init {}
--GI  [ID:19,KIND:2,SYMBNR:118,X:32,Y:34,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC19,COLOR:12,TOid:10]}] [ID:20,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:21,NAME:'
--GICtasks'],PARENT:{19}]

where
  proc ptask[
      in i1: num, 
      in i2: num, 
      out o: num, 
      store runs: num -> *str, 
      store random: real, 
      store tasks: $str, 
      val name: str
      | pre i1=i2,
        prio select(name,tasks,random)]
  := 
o <- i1 delay nexp(1.,random(random)),
runs <- [ c:dom(runs)| if c=i1 then runs.c cat <| name |> else runs.c fi],
tasks <- ins(name,tasks)
  ;

end;

export sys task22[
    in i1: num, 
    in i2: num, 
    out o1: num, 
    out o2: num, 
    val self: str]
--GIH [ID:1,KIND:3,SYMBNR:3,X:13,Y:18,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:1,C
--GICOLOR:12,TOid:13]}] [ID:2,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:3,NAME:'i1'],P
--GICARENT:{1}]
--GIH [ID:4,KIND:3,SYMBNR:4,X:94,Y:19,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:4,C
--GICOLOR:12,TOid:13]}] [ID:5,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:6,NAME:'i2'],P
--GICARENT:{4}]
--GIH [ID:7,KIND:4,SYMBNR:4,X:6,Y:6,XSIZE:8,YSIZE:8,COLOR:69388] [ID:8,KIND:-2,X
--GICPERC:50,YPERC:145,NAME:[ID:9,NAME:'o1'],PARENT:{7}]
--GIH [ID:10,KIND:4,SYMBNR:4,X:90,Y:7,XSIZE:8,YSIZE:8,COLOR:69388] [ID:11,KIND:-
--GIC2,XPERC:50,YPERC:145,NAME:[ID:12,NAME:'o2'],PARENT:{10}]
:= 
  ptask(in i1, in i2, out o1, out o2, store runs, store random, store tasks, val self),
--GI  [ID:13,KIND:6,SYMBNR:122,X:48,Y:15,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:
--GIC13,COLOR:12,TOid:10],[ID:13,COLOR:12,TOid:7]}] [ID:14,KIND:-2,XPERC:50,YPER
--GICC:120,NAME:[ID:15,NAME:'ptask'],PARENT:{13}]

  store random : real in system,
--GI  [ID:16,KIND:2,SYMBNR:118,X:49,Y:35,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC16,COLOR:12,TOid:13]}] [ID:17,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:18,NAME:'
--GICrandom'],PARENT:{16}]

  store runs : num -> *str in global init {},
--GI  [ID:19,KIND:2,SYMBNR:118,X:65,Y:36,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC19,COLOR:12,TOid:13]}] [ID:20,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:21,NAME:'
--GICruns'],PARENT:{19}]

  store tasks : $str in global init {}
--GI  [ID:22,KIND:2,SYMBNR:118,X:32,Y:34,XSIZE:4,YSIZE:4,COLOR:65292,LINES:{[ID:
--GIC22,COLOR:12,TOid:13]}] [ID:23,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:24,NAME:'
--GICtasks'],PARENT:{22}]

where
  proc ptask[
      in i1: num, 
      in i2: num, 
      out o1: num, 
      out o2: num, 
      store runs: num -> *str, 
      store random: real, 
      store tasks: $str, 
      val name: str
      | pre i1=i2,
        prio select(name,tasks,random)]
  := 
o1 <- i1 delay nexp(1.,random),
o2 <- i1 delay nexp(1.,random(random)),
runs <- [ c:dom(runs)| if c=i1 then runs.c cat <| name |> else runs.c fi],
tasks <- ins(name,tasks)
  ;

end;

sys input_workflow_log[
    out case_trace: trace]
--GIH [ID:1,KIND:4,SYMBNR:4,X:66,Y:36,XSIZE:8,YSIZE:8,COLOR:69388] [ID:2,KIND:-2
--GIC,XPERC:50,YPERC:145,NAME:[ID:3,NAME:'case_trace'],PARENT:{1}]
:= 
  channel input_workflow_log : trace in user,
--GI  [ID:4,KIND:1,SYMBNR:1,X:13,Y:38,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:4,C
--GICOLOR:12,TOid:7]}] [ID:5,KIND:-2,XPERC:65,YPERC:170,NAME:[ID:6,NAME:'input_w
--GICorkflow_log'],PARENT:{4}]

  transfer(in input_workflow_log, out case_trace),
--GI  [ID:7,KIND:6,SYMBNR:122,X:35,Y:34,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:7
--GIC,COLOR:12,TOid:1]}] [ID:8,KIND:-2,XPERC:50,YPERC:122,NAME:[ID:9,NAME:'trans
--GICfer'],PARENT:{7}]

  channel input_trace_text : str,
--GI  [ID:10,KIND:1,SYMBNR:1,X:13,Y:9,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:10,
--GICCOLOR:12,TOid:19]}] [ID:11,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:12,NAME:'inp
--GICut_trace_text'],PARENT:{10}]

  channel input_log_text : $str,
--GI  [ID:13,KIND:1,SYMBNR:1,X:52,Y:10,XSIZE:8,YSIZE:8,COLOR:69388,LINES:{[ID:13
--GIC,COLOR:12,TOid:16]}] [ID:14,KIND:-2,XPERC:50,YPERC:145,NAME:[ID:15,NAME:'in
--GICput_log_text'],PARENT:{13}]

  unpack(in input_log_text, out input_log_text, out input_trace_text),
--GI  [ID:16,KIND:6,SYMBNR:122,X:33,Y:7,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:1
--GIC6,COLOR:12,TOid:10],[ID:16,COLOR:12,TOid:13]}] [ID:17,KIND:-2,XPERC:50,YPER
--GICC:121,NAME:[ID:18,NAME:'unpack'],PARENT:{16}]

  make_list(in input_trace_text, out input_workflow_log)
--GI  [ID:19,KIND:6,SYMBNR:122,X:11,Y:23,XSIZE:8,YSIZE:8,COLOR:67084,LINES:{[ID:
--GIC19,COLOR:12,TOid:4]}] [ID:20,KIND:-2,XPERC:50,YPERC:122,NAME:[ID:21,NAME:'m
--GICake_list'],PARENT:{19}]
;

