/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.JGraph;
import com.jgraph.graph.CellHandle;
import com.jgraph.graph.CellMapper;
import com.jgraph.graph.CellView;
import com.jgraph.graph.CellViewRenderer;
import com.jgraph.graph.DefaultGraphCellEditor;
import com.jgraph.graph.GraphCellEditor;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.GraphContext;
import com.jgraph.graph.GraphModel;
import com.jgraph.graph.Port;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.SwingUtilities;

public abstract class AbstractCellView
implements CellView,
Serializable {
    protected static GraphCellEditor cellEditor = new DefaultGraphCellEditor();
    protected JGraph graph = null;
    protected CellMapper mapper = null;
    protected Object cell = null;
    protected CellView parent = null;
    protected List childViews = new ArrayList();
    protected Map attributes = new Hashtable();

    public AbstractCellView(Object object, JGraph jGraph, CellMapper cellMapper) {
        this.cell = object;
        this.graph = jGraph;
        this.mapper = cellMapper;
        this.update();
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public GraphModel getModel() {
        return this.graph.getModel();
    }

    public CellMapper getMapper() {
        return this.mapper;
    }

    public Object getCell() {
        return this.cell;
    }

    public void refresh(boolean bl) {
        Object object;
        boolean bl2;
        if (this.mapper != null && this.getModel() != null) {
            CellView cellView = this.mapper.getMapping(this.getModel().getParent(this.cell), bl);
            if (cellView != this.parent) {
                this.removeFromParent();
            }
            this.parent = cellView;
        }
        if (bl2 = this.graph.getModel().isOrdered()) {
            this.childViews.clear();
        }
        int n = 0;
        while (n < this.getModel().getChildCount(this.cell)) {
            object = this.getModel().getChild(this.cell, n);
            CellView cellView = this.mapper.getMapping(object, bl);
            if (!(object instanceof Port || this.childViews.contains(cellView) && !bl2)) {
                this.childViews.add(cellView);
            }
            ++n;
        }
        object = this.getModel().getAttributes(this.cell);
        if (object != null) {
            this.attributes.putAll(GraphConstants.cloneMap((Map)object));
        }
    }

    public void update() {
        Iterator iterator = this.childViews.iterator();
        while (iterator.hasNext()) {
            ((CellView)iterator.next()).update();
        }
    }

    public CellView getParentView() {
        return this.parent;
    }

    public CellView[] getChildViews() {
        CellView[] cellViewArray = new CellView[this.childViews.size()];
        this.childViews.toArray(cellViewArray);
        return cellViewArray;
    }

    public static CellView[] getDescendantViews(CellView[] cellViewArray) {
        Object object;
        Stack<CellView> stack = new Stack<CellView>();
        int n = 0;
        while (n < cellViewArray.length) {
            stack.add(cellViewArray[n]);
            ++n;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!stack.isEmpty()) {
            object = (CellView)stack.pop();
            CellView[] cellViewArray2 = object.getChildViews();
            int n2 = 0;
            while (n2 < cellViewArray2.length) {
                stack.add(cellViewArray2[n2]);
                ++n2;
            }
            arrayList.add(object);
        }
        object = new CellView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public void removeFromParent() {
        if (this.parent instanceof AbstractCellView) {
            List list = ((AbstractCellView)this.parent).childViews;
            list.remove(this);
        }
    }

    public boolean isLeaf() {
        return this.childViews.isEmpty();
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map map) {
        GraphConstants.applyMap(map, this.attributes);
        Iterator iterator = this.attributes.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (this.getRenderer().supportsAttribute(k) || this.isControlAttribute(k)) continue;
            iterator.remove();
        }
        this.update();
    }

    public boolean isControlAttribute(Object object) {
        return object.equals(GraphConstants.SIZEABLE) || object.equals(GraphConstants.MOVEABLE) || object.equals(GraphConstants.EDITABLE) || object.equals(GraphConstants.BENDABLE) || object.equals(GraphConstants.CONNECTABLE) || object.equals(GraphConstants.VISIBLE) || object.equals(GraphConstants.DISCONNECTABLE);
    }

    public abstract Rectangle getBounds();

    public static Rectangle getBounds(CellView[] cellViewArray) {
        if (cellViewArray != null && cellViewArray.length > 0) {
            Rectangle rectangle = null;
            int n = 0;
            while (n < cellViewArray.length) {
                Rectangle rectangle2;
                if (cellViewArray[n] != null && (rectangle2 = cellViewArray[n].getBounds()) != null) {
                    if (rectangle == null) {
                        rectangle = new Rectangle(rectangle2);
                    } else {
                        SwingUtilities.computeUnion(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
                    }
                }
                ++n;
            }
            return rectangle;
        }
        return null;
    }

    public void setBounds(Rectangle rectangle) {
        Point point;
        Rectangle rectangle2 = this.getBounds();
        Point point2 = rectangle.getLocation();
        if (!point2.equals(point = rectangle2.getLocation())) {
            this.translate(point2.x - point.x, point2.y - point.y);
        }
        Dimension dimension = rectangle.getSize();
        Dimension dimension2 = rectangle2.getSize();
        if (!dimension2.equals(dimension) && dimension2.width > 0 && dimension2.height > 0) {
            double d = (double)dimension.width / (double)dimension2.width;
            double d2 = (double)dimension.height / (double)dimension2.height;
            this.scale(d, d2, point2);
        }
    }

    protected void translate(int n, int n2) {
        if (this.isLeaf()) {
            GraphConstants.translate(this.getAttributes(), n, n2);
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof AbstractCellView)) continue;
                ((AbstractCellView)e).translate(n, n2);
            }
        }
    }

    protected void scale(double d, double d2, Point point) {
        if (this.isLeaf()) {
            GraphConstants.scale(this.getAttributes(), d, d2, point);
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof AbstractCellView)) continue;
                ((AbstractCellView)e).scale(d, d2, point);
            }
        }
    }

    public boolean intersects(Graphics graphics, Rectangle rectangle) {
        if (this.isLeaf()) {
            Rectangle rectangle2 = this.getBounds();
            if (rectangle2 != null) {
                return rectangle2.intersects(rectangle);
            }
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                if (!((CellView)iterator.next()).intersects(graphics, rectangle)) continue;
                return true;
            }
        }
        return false;
    }

    public Component getRendererComponent(JGraph jGraph, boolean bl, boolean bl2, boolean bl3) {
        CellViewRenderer cellViewRenderer = this.getRenderer();
        if (cellViewRenderer != null) {
            return cellViewRenderer.getRendererComponent(jGraph, this, bl, bl2, bl3);
        }
        return null;
    }

    protected abstract CellViewRenderer getRenderer();

    public abstract CellHandle getHandle(GraphContext var1);

    public GraphCellEditor getEditor() {
        return cellEditor;
    }
}

