/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.JGraph;
import com.jgraph.graph.CellView;
import com.jgraph.graph.GraphConstants;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class BasicMarqueeHandler {
    protected transient Cursor previousCursor = null;
    protected Rectangle marqueeBounds;
    protected Rectangle lastVisibleRect;
    protected Point startPoint;
    protected Point currentPoint;

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        return mouseEvent.isAltDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent != null && !mouseEvent.isConsumed() && this.marqueeBounds != null) {
                if (!(mouseEvent.getSource() instanceof JGraph)) {
                    throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
                }
                JGraph jGraph = (JGraph)mouseEvent.getSource();
                Rectangle rectangle = jGraph.fromScreen(new Rectangle(this.marqueeBounds));
                CellView[] cellViewArray = jGraph.getView().getRoots(rectangle);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n = 0;
                while (n < cellViewArray.length) {
                    if (GraphConstants.isVisible(cellViewArray[n].getAttributes()) && rectangle.contains(cellViewArray[n].getBounds())) {
                        arrayList.add(cellViewArray[n].getCell());
                    }
                    ++n;
                }
                Object[] objectArray = arrayList.toArray();
                jGraph.getUI().selectCellsForEvent(jGraph, objectArray, mouseEvent);
                jGraph.setCursor(this.previousCursor);
                Rectangle rectangle2 = new Rectangle(this.marqueeBounds);
                ++rectangle2.width;
                ++rectangle2.height;
                jGraph.repaint(rectangle2);
                mouseEvent.consume();
            }
            Object var10_9 = null;
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
            throw throwable;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.startPoint != null) {
            if (!(mouseEvent.getSource() instanceof JGraph)) {
                throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
            }
            JGraph jGraph = (JGraph)mouseEvent.getSource();
            Graphics graphics = jGraph.getGraphics();
            Color color = jGraph.getBackground();
            Color color2 = jGraph.getMarqueeColor();
            graphics.setColor(color2);
            graphics.setXORMode(color);
            this.overlay(graphics);
            this.currentPoint = mouseEvent.getPoint();
            this.marqueeBounds = new Rectangle(this.startPoint);
            this.marqueeBounds.add(this.currentPoint);
            graphics.setColor(color);
            graphics.setXORMode(color2);
            this.overlay(graphics);
            mouseEvent.consume();
        }
    }

    public void paint(Graphics graphics) {
        this.overlay(graphics);
    }

    protected void overlay(Graphics graphics) {
        if (this.marqueeBounds != null) {
            graphics.drawRect(this.marqueeBounds.x, this.marqueeBounds.y, this.marqueeBounds.width, this.marqueeBounds.height);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            if (!(mouseEvent.getSource() instanceof JGraph)) {
                throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
            }
            JGraph jGraph = (JGraph)mouseEvent.getSource();
            this.startPoint = mouseEvent.getPoint();
            this.marqueeBounds = new Rectangle(this.startPoint);
            this.previousCursor = jGraph.getCursor();
            jGraph.setCursor(new Cursor(1));
            this.lastVisibleRect = jGraph.getVisibleRect();
            mouseEvent.consume();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

