/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.event.GraphModelEvent;
import com.jgraph.event.GraphModelListener;
import com.jgraph.graph.CellView;
import com.jgraph.graph.ConnectionSet;
import com.jgraph.graph.DefaultGraphCell;
import com.jgraph.graph.Edge;
import com.jgraph.graph.GraphCell;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.GraphModel;
import com.jgraph.graph.GraphView;
import com.jgraph.graph.ParentMap;
import com.jgraph.graph.Port;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class DefaultGraphModel
extends UndoableEditSupport
implements Serializable,
GraphModel {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected transient Iterator emptyIterator = new EmptyIterator();
    protected List roots = new ArrayList();
    protected boolean asksAllowsChildren = false;
    protected boolean attributeStore = false;
    static /* synthetic */ Class class$com$jgraph$event$GraphModelListener;

    public DefaultGraphModel() {
    }

    public DefaultGraphModel(boolean bl) {
        this.attributeStore = bl;
    }

    public int getRootCount() {
        return this.roots.size();
    }

    public Object getRootAt(int n) {
        return this.roots.get(n);
    }

    public int getIndexOfRoot(Object object) {
        return this.roots.indexOf(object);
    }

    public boolean contains(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            return this.roots.contains(((DefaultMutableTreeNode)object).getRoot());
        }
        return this.roots.contains(object);
    }

    public boolean isAttributeStore() {
        return this.attributeStore;
    }

    public Map getAttributes(Object object) {
        if (object instanceof GraphCell) {
            return ((GraphCell)object).getAttributes();
        }
        return null;
    }

    public Object getSource(Object object) {
        if (object instanceof Edge) {
            return ((Edge)object).getSource();
        }
        return null;
    }

    public Object getTarget(Object object) {
        if (object instanceof Edge) {
            return ((Edge)object).getTarget();
        }
        return null;
    }

    public boolean acceptsSource(Object object, Object object2) {
        return true;
    }

    public boolean acceptsTarget(Object object, Object object2) {
        return true;
    }

    public Iterator edges(Object object) {
        if (object instanceof Port) {
            return ((Port)object).edges();
        }
        return this.emptyIterator;
    }

    public Object getParent(Object object) {
        if (object != null && object instanceof TreeNode) {
            return ((TreeNode)object).getParent();
        }
        return null;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        return ((TreeNode)object).getIndex((TreeNode)object2);
    }

    public Object getChild(Object object, int n) {
        return ((TreeNode)object).getChildAt(n);
    }

    public int getChildCount(Object object) {
        if (object instanceof TreeNode) {
            return ((TreeNode)object).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        if (this.asksAllowsChildren) {
            return !((TreeNode)object).getAllowsChildren();
        }
        return ((TreeNode)object).isLeaf();
    }

    public void insert(Object[] objectArray, ConnectionSet connectionSet, ParentMap parentMap, Map map) {
        Object object;
        if (map != null && this.isAttributeStore()) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                ((GraphCell)entry.getKey()).setAttributes((Map)entry.getValue());
            }
            map = null;
        }
        if ((object = this.createInsertEdit(objectArray, connectionSet, parentMap, map)) != null) {
            ((GraphModelEdit)object).execute();
            this.postEdit((UndoableEdit)object);
        }
    }

    public void remove(Object[] objectArray) {
        GraphModelEdit graphModelEdit = this.createRemoveEdit(objectArray);
        if (graphModelEdit != null) {
            graphModelEdit.execute();
            this.postEdit(graphModelEdit);
        }
    }

    public void edit(ConnectionSet connectionSet, Map map, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        if (map == null && (connectionSet == null || connectionSet.isEmpty()) && parentMap == null && undoableEditArray != null && undoableEditArray.length == 1) {
            this.postEdit(undoableEditArray[0]);
        } else {
            GraphModelEdit graphModelEdit = this.createCellEdit(connectionSet, map, parentMap, undoableEditArray);
            if (graphModelEdit != null) {
                graphModelEdit.execute();
                this.postEdit(graphModelEdit);
            }
        }
    }

    public void toBack(Object[] objectArray) {
        GraphModelLayerEdit graphModelLayerEdit = new GraphModelLayerEdit(objectArray, -2);
        graphModelLayerEdit.execute();
        this.postEdit(graphModelLayerEdit);
    }

    public void toFront(Object[] objectArray) {
        GraphModelLayerEdit graphModelLayerEdit = new GraphModelLayerEdit(objectArray, -1);
        graphModelLayerEdit.execute();
        this.postEdit(graphModelLayerEdit);
    }

    public boolean isOrdered() {
        return this.isAttributeStore();
    }

    protected GraphModelEdit createInsertEdit(Object[] objectArray, ConnectionSet connectionSet, ParentMap parentMap, Map map) {
        GraphModelEdit graphModelEdit = this.createEdit(objectArray, null, map, null, connectionSet, parentMap);
        if (graphModelEdit != null) {
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected GraphModelEdit createRemoveEdit(Object[] objectArray) {
        ParentMap parentMap;
        ConnectionSet connectionSet = ConnectionSet.create(this, objectArray, true);
        GraphModelEdit graphModelEdit = this.createEdit(null, objectArray, null, null, connectionSet, parentMap = ParentMap.create(this, objectArray, true));
        if (graphModelEdit != null) {
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected GraphModelEdit createCellEdit(ConnectionSet connectionSet, Map map, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        GraphModelEdit graphModelEdit = this.createEdit(null, null, null, map, connectionSet, parentMap);
        if (graphModelEdit != null) {
            if (undoableEditArray != null) {
                int n = 0;
                while (n < undoableEditArray.length) {
                    graphModelEdit.addEdit(undoableEditArray[n]);
                    ++n;
                }
            }
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected GraphModelEdit createEdit(Object[] objectArray, Object[] objectArray2, Map map, Map map2, ConnectionSet connectionSet, ParentMap parentMap) {
        return new GraphModelEdit(objectArray, objectArray2, connectionSet, map2, parentMap, map);
    }

    protected Object[] handleInsert(Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (this.getParent(objectArray[n]) == null) {
                    this.roots.add(objectArray[n]);
                }
                ++n;
            }
            objectArray2 = DefaultGraphModel.getDescendants(this, objectArray).toArray();
        }
        return objectArray2;
    }

    protected Object[] handleRemove(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (this.getParent(objectArray[n]) == null && this.roots.remove(objectArray[n])) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray();
    }

    protected ParentMap handleParentMap(ParentMap parentMap) {
        if (parentMap != null) {
            ParentMap parentMap2 = new ParentMap();
            Iterator iterator = parentMap.entries();
            while (iterator.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)iterator.next();
                MutableTreeNode mutableTreeNode = (MutableTreeNode)entry.getChild();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)entry.getParent();
                parentMap2.addEntry(mutableTreeNode, this.getParent(mutableTreeNode));
                if (defaultMutableTreeNode == null) {
                    mutableTreeNode.removeFromParent();
                } else {
                    defaultMutableTreeNode.add(mutableTreeNode);
                }
                boolean bl = this.roots.contains(mutableTreeNode);
                if (defaultMutableTreeNode == null && !bl) {
                    this.roots.add(mutableTreeNode);
                    continue;
                }
                if (defaultMutableTreeNode == null || !bl) continue;
                this.roots.remove(mutableTreeNode);
            }
            return parentMap2;
        }
        return null;
    }

    protected Map handlePropertyMap(Map map) {
        if (map != null) {
            Hashtable<GraphCell, Map> hashtable = new Hashtable<GraphCell, Map>();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                GraphCell graphCell = (GraphCell)entry.getKey();
                hashtable.put(graphCell, GraphConstants.cloneMap(this.getAttributes(graphCell)));
                Map map2 = (Map)entry.getValue();
                graphCell.setAttributes(map2);
            }
            return hashtable;
        }
        return null;
    }

    protected ConnectionSet handleConnectionSet(ConnectionSet connectionSet) {
        if (connectionSet != null) {
            ConnectionSet connectionSet2 = new ConnectionSet();
            Iterator iterator = connectionSet.connections();
            while (iterator.hasNext()) {
                ConnectionSet.Connection connection = (ConnectionSet.Connection)iterator.next();
                Object object = connection.getEdge();
                if (connection.isSource()) {
                    connectionSet2.connect(object, this.getSource(object), true);
                } else {
                    connectionSet2.connect(object, this.getTarget(object), false);
                }
                this.handleConnection(connection);
            }
            return connectionSet2;
        }
        return null;
    }

    protected void handleConnection(ConnectionSet.Connection connection) {
        Object object = connection.getEdge();
        Object object2 = connection.isSource() ? this.getSource(object) : this.getTarget(object);
        Object object3 = connection.getPort();
        if (object3 != object2) {
            this.connect(object, object2, connection.isSource(), true);
            if (this.contains(object3) && this.contains(object)) {
                this.connect(object, object3, connection.isSource(), false);
            }
        }
    }

    protected void connect(Object object, Object object2, boolean bl, boolean bl2) {
        if (object2 instanceof Port) {
            if (bl2) {
                ((Port)object2).remove(object);
            } else {
                ((Port)object2).add(object);
            }
        }
        if (bl2) {
            object2 = null;
        }
        if (object instanceof Edge) {
            if (bl) {
                ((Edge)object).setSource(object2);
            } else {
                ((Edge)object).setTarget(object2);
            }
        }
    }

    public void addGraphModelListener(GraphModelListener graphModelListener) {
        this.listenerList.add(class$com$jgraph$event$GraphModelListener == null ? (class$com$jgraph$event$GraphModelListener = DefaultGraphModel.class$("com.jgraph.event.GraphModelListener")) : class$com$jgraph$event$GraphModelListener, graphModelListener);
    }

    public void removeGraphModelListener(GraphModelListener graphModelListener) {
        this.listenerList.remove(class$com$jgraph$event$GraphModelListener == null ? (class$com$jgraph$event$GraphModelListener = DefaultGraphModel.class$("com.jgraph.event.GraphModelListener")) : class$com$jgraph$event$GraphModelListener, graphModelListener);
    }

    protected void fireGraphChanged(Object object, GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray = this.listenerList.getListenerList();
        GraphModelEvent graphModelEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$jgraph$event$GraphModelListener == null ? DefaultGraphModel.class$("com.jgraph.event.GraphModelListener") : class$com$jgraph$event$GraphModelListener)) {
                if (graphModelEvent == null) {
                    graphModelEvent = new GraphModelEvent(object, graphModelChange);
                }
                ((GraphModelListener)objectArray[n + 1]).graphChanged(graphModelEvent);
            }
            n -= 2;
        }
    }

    public GraphModelListener[] getGraphModelListeners() {
        return (GraphModelListener[])this.listenerList.getListeners(class$com$jgraph$event$GraphModelListener == null ? (class$com$jgraph$event$GraphModelListener = DefaultGraphModel.class$("com.jgraph.event.GraphModelListener")) : class$com$jgraph$event$GraphModelListener);
    }

    public static Object[] getRoots(GraphModel graphModel) {
        if (graphModel instanceof DefaultGraphModel) {
            return ((DefaultGraphModel)graphModel).roots.toArray();
        }
        Object[] objectArray = null;
        if (graphModel != null) {
            objectArray = new Object[graphModel.getRootCount()];
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = graphModel.getRootAt(n);
                ++n;
            }
        }
        return objectArray;
    }

    public static Set getEdges(GraphModel graphModel, Object[] objectArray) {
        Set set = DefaultGraphModel.getDescendants(graphModel, objectArray);
        HashSet hashSet = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = graphModel.edges(iterator.next());
            while (iterator2.hasNext()) {
                hashSet.add(iterator2.next());
            }
        }
        hashSet.removeAll(set);
        return hashSet;
    }

    public static Set getDescendants(GraphModel graphModel, Object[] objectArray) {
        if (objectArray != null) {
            Stack<Object> stack = new Stack<Object>();
            int n = 0;
            while (n < objectArray.length) {
                stack.add(objectArray[n]);
                ++n;
            }
            HashSet hashSet = new HashSet();
            while (!stack.isEmpty()) {
                Object e = stack.pop();
                int n2 = 0;
                while (n2 < graphModel.getChildCount(e)) {
                    stack.add(graphModel.getChild(e, n2));
                    ++n2;
                }
                hashSet.add(e);
            }
            return hashSet;
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.emptyIterator = new EmptyIterator();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class EmptyIterator
    implements Iterator,
    Serializable {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }

    public class GraphModelLayerEdit
    extends GraphView.GraphViewLayerEdit
    implements GraphModelEvent.GraphModelChange {
        protected Object[] parents;

        public GraphModelLayerEdit(Object[] objectArray, int n) {
            super(DefaultGraphModel.this, objectArray, n);
            HashSet<TreeNode> hashSet = new HashSet<TreeNode>();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof TreeNode) {
                    hashSet.add(((TreeNode)objectArray[n2]).getParent());
                }
                ++n2;
            }
            this.parents = hashSet.toArray();
        }

        public Object getSource() {
            return DefaultGraphModel.this;
        }

        public Object[] getChanged() {
            return this.parents;
        }

        public Object[] getInserted() {
            return null;
        }

        public Object[] getRemoved() {
            return null;
        }

        public CellView[] getViews(GraphView graphView) {
            return null;
        }

        public void putViews(GraphView graphView, CellView[] cellViewArray) {
        }

        protected void updateListeners() {
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        protected List getParentList(Object object) {
            List list = null;
            if (object instanceof DefaultMutableTreeNode) {
                TreeNode treeNode = ((DefaultMutableTreeNode)object).getParent();
                list = treeNode instanceof DefaultGraphCell ? ((DefaultGraphCell)treeNode).getChildren() : DefaultGraphModel.this.roots;
            }
            return list;
        }
    }

    public class GraphModelEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphModelChange {
        protected Object[] insert;
        protected Object[] changed;
        protected Object[] remove;
        protected Object[] context;
        protected Object[] inserted;
        protected Object[] removed;
        protected Map propertyMap;
        protected Map attributeMap;
        protected ParentMap parentMap;
        protected ConnectionSet connectionSet;
        protected Map cellViews = new Hashtable();

        public GraphModelEdit(Object[] objectArray, ConnectionSet connectionSet, ParentMap parentMap) {
            this(null, objectArray, connectionSet, null, parentMap, null);
        }

        public GraphModelEdit(Object[] objectArray, ConnectionSet connectionSet, ParentMap parentMap, Map map) {
            this(objectArray, null, connectionSet, null, parentMap, map);
        }

        public GraphModelEdit(ConnectionSet connectionSet, Map map, ParentMap parentMap) {
            this(null, null, connectionSet, map, parentMap, null);
        }

        public GraphModelEdit(Object[] objectArray, Object[] objectArray2, ConnectionSet connectionSet, Map map, ParentMap parentMap, Map map2) {
            Object[] objectArray3;
            this.insert = objectArray;
            this.remove = objectArray2;
            this.connectionSet = connectionSet;
            this.propertyMap = map;
            this.parentMap = parentMap;
            this.attributeMap = map2;
            if (parentMap != null && (objectArray3 = parentMap.emptyParents()) != null && objectArray3.length > 0) {
                if (this.remove == null) {
                    this.remove = new Object[0];
                }
                Object[] objectArray4 = new Object[this.remove.length + objectArray3.length];
                System.arraycopy(this.remove, 0, objectArray4, 0, this.remove.length);
                System.arraycopy(objectArray3, 0, objectArray4, this.remove.length, objectArray3.length);
                this.remove = objectArray4;
            }
        }

        public boolean isSignificant() {
            return true;
        }

        public Object getSource() {
            return DefaultGraphModel.this;
        }

        public Object[] getChanged() {
            return this.changed;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Object[] getInserted() {
            return this.inserted;
        }

        public Object[] getRemoved() {
            return this.removed;
        }

        public Map getAttributeMap() {
            return this.attributeMap;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            HashSet hashSet = new HashSet();
            if (this.propertyMap != null) {
                hashSet.addAll(this.propertyMap.keySet());
            }
            if (this.parentMap != null) {
                hashSet.addAll(this.parentMap.getChangedNodes());
            }
            if (this.connectionSet != null) {
                hashSet.addAll(this.connectionSet.getChangedEdges());
            }
            if (this.remove != null) {
                int n = 0;
                while (n < this.remove.length) {
                    hashSet.remove(this.remove[n]);
                    ++n;
                }
            }
            this.changed = hashSet.toArray();
            Set set = DefaultGraphModel.getEdges(DefaultGraphModel.this, this.changed);
            this.context = set.toArray();
            this.inserted = this.insert;
            this.removed = this.remove;
            this.remove = DefaultGraphModel.this.handleInsert(this.inserted);
            this.parentMap = DefaultGraphModel.this.handleParentMap(this.parentMap);
            this.connectionSet = DefaultGraphModel.this.handleConnectionSet(this.connectionSet);
            this.insert = DefaultGraphModel.this.handleRemove(this.removed);
            this.propertyMap = DefaultGraphModel.this.handlePropertyMap(this.propertyMap);
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        public void putViews(GraphView graphView, CellView[] cellViewArray) {
            if (graphView != null && cellViewArray != null) {
                this.cellViews.put(graphView, cellViewArray);
            }
        }

        public CellView[] getViews(GraphView graphView) {
            return (CellView[])this.cellViews.get(graphView);
        }

        public String toString() {
            int n;
            String string = new String();
            if (this.inserted != null) {
                string = string + "Inserted:\n";
                n = 0;
                while (n < this.inserted.length) {
                    string = string + "  " + this.inserted[n] + "\n";
                    ++n;
                }
            } else {
                string = string + "None inserted\n";
            }
            if (this.removed != null) {
                string = string + "Removed:\n";
                n = 0;
                while (n < this.removed.length) {
                    string = string + "  " + this.removed[n] + "\n";
                    ++n;
                }
            } else {
                string = string + "None removed\n";
            }
            if (this.changed != null && this.changed.length > 0) {
                string = string + "Changed:\n";
                n = 0;
                while (n < this.changed.length) {
                    string = string + "  " + this.changed[n] + "\n";
                    ++n;
                }
            } else {
                string = string + "None changed\n";
            }
            string = this.parentMap != null ? string + this.parentMap.toString() : string + "No parent map\n";
            return string;
        }
    }
}

