/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.JGraph;
import com.jgraph.event.GraphSelectionEvent;
import com.jgraph.event.GraphSelectionListener;
import com.jgraph.graph.CellPlaceHolder;
import com.jgraph.graph.DefaultGraphModel;
import com.jgraph.graph.GraphSelectionModel;
import com.jgraph.graph.Port;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;

public class DefaultGraphSelectionModel
implements GraphSelectionModel,
Cloneable,
Serializable {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    public static final int SELECTED = -1;
    protected JGraph graph;
    protected SwingPropertyChangeSupport changeSupport;
    protected EventListenerList listenerList = new EventListenerList();
    protected int selectionMode;
    protected boolean childrenSelectable = true;
    protected Map cellStates = new Hashtable();
    protected List selection = new ArrayList();
    static /* synthetic */ Class class$com$jgraph$event$GraphSelectionListener;

    public DefaultGraphSelectionModel(JGraph jGraph) {
        this.graph = jGraph;
    }

    public void setSelectionMode(int n) {
        int n2 = this.selectionMode;
        this.selectionMode = n;
        if (this.selectionMode != 4 && this.selectionMode != 1) {
            this.selectionMode = 4;
        }
        if (n2 != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(n2), new Integer(this.selectionMode));
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setChildrenSelectable(boolean bl) {
        this.childrenSelectable = bl;
    }

    public boolean isChildrenSelectable() {
        return this.childrenSelectable;
    }

    public void setSelectionCell(Object object) {
        if (object == null) {
            this.setSelectionCells(null);
        } else {
            this.setSelectionCells(new Object[]{object});
        }
    }

    public void setSelectionCells(Object[] objectArray) {
        if (objectArray != null) {
            if (this.selectionMode == 1 && objectArray.length > 0) {
                objectArray = new Object[]{objectArray[objectArray.length - 1]};
            }
            Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
            this.cellStates.clear();
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    vector.addElement(new CellPlaceHolder(objectArray[n], !this.selection.remove(objectArray[n])));
                    this.select(arrayList, objectArray[n]);
                }
                ++n;
            }
            Iterator iterator = this.selection.iterator();
            while (iterator.hasNext()) {
                vector.addElement(new CellPlaceHolder(iterator.next(), false));
            }
            this.selection = arrayList;
            if (vector.size() > 0) {
                this.notifyCellChange(vector);
            }
        }
    }

    public void addSelectionCell(Object object) {
        if (object != null) {
            this.addSelectionCells(new Object[]{object});
        }
    }

    public void addSelectionCells(Object[] objectArray) {
        if (objectArray != null) {
            if (this.selectionMode == 1) {
                this.setSelectionCells(objectArray);
            } else {
                Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
                int n = 0;
                while (n < objectArray.length) {
                    boolean bl;
                    if (objectArray[n] != null && (bl = this.select(this.selection, objectArray[n]))) {
                        vector.addElement(new CellPlaceHolder(objectArray[n], true));
                    }
                    ++n;
                }
                if (vector.size() > 0) {
                    this.notifyCellChange(vector);
                }
            }
        }
    }

    public void removeSelectionCell(Object object) {
        if (object != null) {
            this.removeSelectionCells(new Object[]{object});
        }
    }

    public void removeSelectionCells(Object[] objectArray) {
        if (objectArray != null) {
            Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
            int n = 0;
            while (n < objectArray.length) {
                boolean bl;
                if (objectArray[n] != null && (bl = this.deselect(objectArray[n]))) {
                    vector.addElement(new CellPlaceHolder(objectArray[n], false));
                }
                ++n;
            }
            if (vector.size() > 0) {
                this.notifyCellChange(vector);
            }
        }
    }

    public Object[] getSelectables() {
        if (this.childrenSelectable) {
            ArrayList arrayList = new ArrayList();
            Stack<Object> stack = new Stack<Object>();
            Object[] objectArray = this.graph.getRoots();
            int n = 0;
            while (n < objectArray.length) {
                stack.add(objectArray[n]);
                ++n;
            }
            while (!stack.isEmpty()) {
                Object e = stack.pop();
                if (!(e instanceof Port)) {
                    arrayList.add(e);
                }
                if (this.getSelectedChildCount(e) == 0) continue;
                int n2 = 0;
                while (n2 < this.graph.getModel().getChildCount(e)) {
                    stack.add(this.graph.getModel().getChild(e, n2));
                    ++n2;
                }
            }
            return arrayList.toArray();
        }
        return this.graph.getRoots();
    }

    public Object getSelectionCell() {
        if (this.selection != null && this.selection.size() > 0) {
            return this.selection.toArray()[0];
        }
        return null;
    }

    public Object[] getSelectionCells() {
        if (this.selection != null) {
            return this.selection.toArray();
        }
        return null;
    }

    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.size();
    }

    public boolean isCellSelected(Object object) {
        int n = this.getSelectedChildCount(object);
        return n == -1;
    }

    public boolean isChildrenSelected(Object object) {
        int n = this.getSelectedChildCount(object);
        return n > 0;
    }

    public boolean isSelectionEmpty() {
        return this.selection.isEmpty();
    }

    public void clearSelection() {
        if (this.selection != null) {
            Object[] objectArray = this.getSelectionCells();
            Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    vector.addElement(new CellPlaceHolder(objectArray[n], false));
                }
                ++n;
            }
            this.selection.clear();
            this.cellStates.clear();
            if (vector.size() > 0) {
                this.notifyCellChange(vector);
            }
        }
    }

    protected int getSelectedChildCount(Object object) {
        if (object != null) {
            Integer n = (Integer)this.cellStates.get(object);
            if (n == null) {
                n = new Integer(0);
                this.cellStates.put(object, n);
            }
            return n;
        }
        return 0;
    }

    protected void setSelectedChildCount(Object object, int n) {
        Integer n2 = new Integer(n);
        this.cellStates.put(object, n2);
    }

    protected boolean select(List list, Object object) {
        if (!this.isCellSelected(object)) {
            Object object2 = this.graph.getModel().getParent(object);
            while (object2 != null) {
                int n = this.getSelectedChildCount(object2);
                if (n == -1) {
                    n = 0;
                }
                this.setSelectedChildCount(object2, ++n);
                this.selection.remove(object2);
                object2 = this.graph.getModel().getParent(object2);
            }
            Object[] objectArray = new Object[]{object};
            Set set = DefaultGraphModel.getDescendants(this.graph.getModel(), objectArray);
            set.remove(object);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null || e instanceof Port) continue;
                this.selection.remove(e);
                this.cellStates.remove(e);
            }
            this.setSelectedChildCount(object, -1);
            return list.add(object);
        }
        return false;
    }

    protected boolean deselect(Object object) {
        if (this.isCellSelected(object)) {
            Object object2 = this.graph.getModel().getParent(object);
            boolean bl = true;
            int n = -1;
            while (object2 != null && n != 0) {
                int n2 = this.getSelectedChildCount(object2);
                if ((n2 += n) == 0 && bl) {
                    n = 0;
                    n2 = -1;
                    this.selection.add(object2);
                }
                this.setSelectedChildCount(object2, n2);
                object2 = this.graph.getModel().getParent(object2);
                bl = false;
            }
            this.cellStates.remove(object);
            return this.selection.remove(object);
        }
        return false;
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.add(class$com$jgraph$event$GraphSelectionListener == null ? (class$com$jgraph$event$GraphSelectionListener = DefaultGraphSelectionModel.class$("com.jgraph.event.GraphSelectionListener")) : class$com$jgraph$event$GraphSelectionListener, graphSelectionListener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.remove(class$com$jgraph$event$GraphSelectionListener == null ? (class$com$jgraph$event$GraphSelectionListener = DefaultGraphSelectionModel.class$("com.jgraph.event.GraphSelectionListener")) : class$com$jgraph$event$GraphSelectionListener, graphSelectionListener);
    }

    protected void fireValueChanged(GraphSelectionEvent graphSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$jgraph$event$GraphSelectionListener == null ? DefaultGraphSelectionModel.class$("com.jgraph.event.GraphSelectionListener") : class$com$jgraph$event$GraphSelectionListener)) {
                ((GraphSelectionListener)objectArray[n + 1]).valueChanged(graphSelectionEvent);
            }
            n -= 2;
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void notifyCellChange(Vector vector) {
        int n = vector.size();
        boolean[] blArray = new boolean[n];
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            CellPlaceHolder cellPlaceHolder = (CellPlaceHolder)vector.elementAt(n2);
            blArray[n2] = cellPlaceHolder.isNew;
            objectArray[n2] = cellPlaceHolder.cell;
            ++n2;
        }
        GraphSelectionEvent graphSelectionEvent = new GraphSelectionEvent(this, objectArray, blArray);
        this.fireValueChanged(graphSelectionEvent);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultGraphSelectionModel defaultGraphSelectionModel = (DefaultGraphSelectionModel)super.clone();
        defaultGraphSelectionModel.changeSupport = null;
        if (this.selection != null) {
            defaultGraphSelectionModel.selection = new ArrayList(this.selection);
        }
        defaultGraphSelectionModel.listenerList = new EventListenerList();
        return defaultGraphSelectionModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

