/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.JGraph;
import com.jgraph.graph.CellView;
import com.jgraph.graph.CellViewRenderer;
import com.jgraph.graph.EdgeView;
import com.jgraph.graph.GraphConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class EdgeRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient Graphics fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
    protected transient FontMetrics metrics;
    protected transient JGraph graph;
    protected transient EdgeView view;
    protected transient int beginDeco;
    protected transient int endDeco;
    protected transient int beginSize;
    protected transient int endSize;
    protected transient int lineStyle;
    protected transient float lineWidth;
    protected transient boolean labelBorder;
    protected transient boolean beginFill;
    protected transient boolean endFill;
    protected transient boolean focus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color borderColor;
    protected transient Color defaultForeground;
    protected transient Color defaultBackground;
    protected transient Color fontColor;
    protected transient Shape beginShape;
    protected transient Shape endShape;
    protected transient Shape lineShape;
    protected transient GeneralPath sharedPath = new GeneralPath(1);
    protected transient float[] lineDash;

    public EdgeRenderer() {
        this.defaultForeground = UIManager.getColor("Tree.textForeground");
        this.defaultBackground = UIManager.getColor("Tree.textBackground");
    }

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof EdgeView && jGraph != null && cellView != null) {
            this.view = (EdgeView)cellView;
            this.graph = jGraph;
            this.focus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.installAttributes(cellView);
            return this;
        }
        return null;
    }

    public boolean intersects(Graphics graphics, CellView cellView, Rectangle rectangle) {
        if (cellView instanceof EdgeView && graphics != null && cellView != null) {
            this.view = (EdgeView)cellView;
            this.installAttributes(this.view);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (graphics2D.hit(rectangle, this.createShape(), true)) {
                return true;
            }
            Rectangle rectangle2 = this.getLabelBounds(this.view);
            if (rectangle2 != null) {
                return rectangle2.intersects(rectangle);
            }
        }
        return false;
    }

    public Rectangle getBounds(CellView cellView) {
        if (cellView instanceof EdgeView && cellView != null) {
            this.view = (EdgeView)cellView;
            this.installAttributes(this.view);
            Rectangle rectangle = this.getPaintBounds(this.view);
            Rectangle rectangle2 = this.getLabelBounds(this.view);
            if (rectangle2 != null) {
                rectangle = rectangle.union(rectangle2);
            }
            int n = (int)Math.ceil(this.lineWidth);
            rectangle.x -= n;
            rectangle.y -= n;
            rectangle.width += 2 * n;
            rectangle.height += 2 * n;
            return rectangle;
        }
        return null;
    }

    public Rectangle getLabelBounds(EdgeView edgeView) {
        Point point = this.getLabelPosition(this.view);
        Dimension dimension = this.getLabelSize(this.view);
        if (point != null && dimension != null) {
            point.translate(-dimension.width / 2, -dimension.height / 2);
            return new Rectangle(point.x, point.y, dimension.width + 1, dimension.height + 1);
        }
        return null;
    }

    public Point getLabelPosition(EdgeView edgeView) {
        Rectangle rectangle = this.getPaintBounds(edgeView);
        Point point = edgeView.getLabelPosition();
        int n = 1000;
        if (point != null && rectangle != null) {
            int n2 = rectangle.x + rectangle.width * point.x / n;
            int n3 = rectangle.y + rectangle.height * point.y / n;
            return new Point(n2, n3);
        }
        return null;
    }

    public Dimension getLabelSize(EdgeView edgeView) {
        String string = edgeView.getGraph().convertValueToString(edgeView.getCell());
        if (string != null && string.toString().length() > 0) {
            this.fontGraphics.setFont(GraphConstants.getFont(edgeView.getAttributes()));
            this.metrics = ((Graphics2D)this.fontGraphics).getFontMetrics();
            int n = this.metrics.stringWidth(string.toString());
            int n2 = this.metrics.getHeight();
            return new Dimension(n, n2);
        }
        return null;
    }

    protected void installAttributes(CellView cellView) {
        Map map = cellView.getAttributes();
        this.beginDeco = GraphConstants.getLineBegin(map);
        this.beginSize = GraphConstants.getBeginSize(map);
        this.beginFill = GraphConstants.isBeginFill(map) && this.isFillable(this.beginDeco);
        this.endDeco = GraphConstants.getLineEnd(map);
        this.endSize = GraphConstants.getEndSize(map);
        this.endFill = GraphConstants.isEndFill(map) && this.isFillable(this.endDeco);
        this.lineWidth = GraphConstants.getLineWidth(map);
        this.lineStyle = GraphConstants.getLineStyle(map);
        this.lineDash = GraphConstants.getDashPattern(map);
        this.borderColor = GraphConstants.getBorderColor(map);
        Color color = GraphConstants.getLineColor(map);
        this.setForeground(color != null ? color : this.defaultForeground);
        Color color2 = GraphConstants.getBackground(map);
        this.setBackground(color2 != null ? color2 : this.defaultBackground);
        this.setOpaque(GraphConstants.isOpaque(map));
        this.setFont(GraphConstants.getFont(map));
        Color color3 = GraphConstants.getForeground(map);
        this.fontColor = color3 != null ? color3 : this.getForeground();
        this.fontGraphics.setFont(this.getFont());
        this.metrics = ((Graphics2D)this.fontGraphics).getFontMetrics();
    }

    protected boolean isFillable(int n) {
        return n != 4 && n != 7 && n != 8;
    }

    public Rectangle getPaintBounds(EdgeView edgeView) {
        this.view = edgeView;
        this.installAttributes(edgeView);
        return this.createShape().getBounds();
    }

    public void paint(Graphics graphics) {
        Shape shape = this.createShape();
        if (shape != null) {
            String string;
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = 0;
            int n2 = 0;
            graphics2D.setStroke(new BasicStroke(this.lineWidth, n, n2));
            graphics.translate(-this.getX(), -this.getY());
            graphics.setColor(this.getForeground());
            if (this.beginShape != null) {
                if (this.beginFill) {
                    graphics2D.fill(this.beginShape);
                }
                graphics2D.draw(this.beginShape);
            }
            if (this.endShape != null) {
                if (this.endFill) {
                    graphics2D.fill(this.endShape);
                }
                graphics2D.draw(this.endShape);
            }
            if (this.lineDash != null) {
                graphics2D.setStroke(new BasicStroke(this.lineWidth, n, n2, 10.0f, this.lineDash, 0.0f));
            }
            graphics2D.draw(this.lineShape);
            if (this.selected) {
                graphics2D.setStroke(GraphConstants.SELECTION_STROKE);
                graphics2D.setColor(this.graph.getHighlightColor());
                if (this.beginShape != null) {
                    graphics2D.draw(this.beginShape);
                }
                graphics2D.draw(this.lineShape);
                if (this.endShape != null) {
                    graphics2D.draw(this.endShape);
                }
            }
            if (this.graph.getEditingCell() != this.view.getCell() && (string = this.graph.convertValueToString(this.view.getCell())) != null) {
                graphics2D.setStroke(new BasicStroke(1.0f));
                graphics.setFont(this.getFont());
                this.paintLabel(graphics, string.toString());
            }
        }
    }

    protected void paintLabel(Graphics graphics, String string) {
        Point point = this.getLabelPosition(this.view);
        if (point != null && string != null && string.length() > 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.metrics.stringWidth(string);
            int n2 = this.metrics.getHeight();
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(point.x - n / 2 - 1, point.y - n2 / 2 - 1, n + 2, n2 + 2);
            }
            if (this.borderColor != null) {
                graphics.setColor(this.borderColor);
                graphics.drawRect(point.x - n / 2 - 1, point.y - n2 / 2 - 1, n + 2, n2 + 2);
            }
            graphics.setColor(this.fontColor);
            ((Graphics2D)graphics).drawString(string, point.x - n / 2, point.y + n2 / 4);
        }
    }

    protected Shape createShape() {
        this.endShape = null;
        this.lineShape = null;
        this.beginShape = null;
        int n = this.view.getPointCount();
        if (n > 1) {
            Point point = new Point(this.view.getPoint(0));
            Point point2 = new Point(this.view.getPoint(n - 1));
            Point point3 = this.view.getPoint(1);
            Point point4 = this.view.getPoint(n - 2);
            if (this.beginDeco != 0) {
                this.beginShape = this.createLineEnd(this.beginSize, this.beginDeco, point3, point);
            }
            if (this.endDeco != 0) {
                this.endShape = this.createLineEnd(this.endSize, this.endDeco, point4, point2);
            }
            this.sharedPath.reset();
            this.sharedPath.moveTo(point.x, point.y);
            if (this.lineStyle == 12 && n > 2) {
                this.sharedPath.quadTo(point3.x, point3.y, point2.x, point2.y);
            } else if (this.lineStyle == 13 && n > 3) {
                this.sharedPath.curveTo(point3.x, point3.y, point4.x, point4.y, point2.x, point2.y);
            } else {
                int n2 = 1;
                while (n2 < n - 1) {
                    Point point5 = this.view.getPoint(n2);
                    this.sharedPath.lineTo(point5.x, point5.y);
                    ++n2;
                }
                this.sharedPath.lineTo(point2.x, point2.y);
            }
            this.lineShape = (GeneralPath)this.sharedPath.clone();
            if (this.endShape != null) {
                this.sharedPath.append(this.endShape, true);
            }
            if (this.beginShape != null) {
                this.sharedPath.append(this.beginShape, true);
            }
            return this.sharedPath;
        }
        return null;
    }

    protected Shape createLineEnd(int n, int n2, Point point, Point point2) {
        int n3 = (int)Math.max(1.0, point2.distance(point));
        int n4 = -(n * (point2.x - point.x) / n3);
        int n5 = -(n * (point2.y - point.y) / n3);
        if (n2 == 9) {
            Polygon polygon = new Polygon();
            polygon.addPoint(point2.x, point2.y);
            polygon.addPoint(point2.x + n4 / 2 + n5 / 3, point2.y + n5 / 2 - n4 / 3);
            Point point3 = new Point(point2);
            point2.setLocation(point2.x + n4, point2.y + n5);
            polygon.addPoint(point2.x, point2.y);
            polygon.addPoint(point3.x + n4 / 2 - n5 / 3, point3.y + n5 / 2 + n4 / 3);
            return polygon;
        }
        if (n2 == 2 || n2 == 1) {
            Polygon polygon = new Polygon();
            polygon.addPoint(point2.x, point2.y);
            polygon.addPoint(point2.x + n4 + n5 / 2, point2.y + n5 - n4 / 2);
            Point point4 = new Point(point2);
            if (n2 == 1) {
                point2.setLocation(point2.x + n4 * 2 / 3, point2.y + n5 * 2 / 3);
                polygon.addPoint(point2.x, point2.y);
            } else if (n2 == 9) {
                point2.setLocation(point2.x + 2 * n4, point2.y + 2 * n5);
                polygon.addPoint(point2.x, point2.y);
            } else {
                point2.setLocation(point2.x + n4, point2.y + n5);
            }
            polygon.addPoint(point4.x + n4 - n5 / 2, point4.y + n5 + n4 / 2);
            return polygon;
        }
        if (n2 == 4) {
            GeneralPath generalPath = new GeneralPath(1, 4);
            generalPath.moveTo(point2.x + n4 + n5 / 2, point2.y + n5 - n4 / 2);
            generalPath.lineTo(point2.x, point2.y);
            generalPath.lineTo(point2.x + n4 - n5 / 2, point2.y + n5 + n4 / 2);
            return generalPath;
        }
        if (n2 == 5) {
            Ellipse2D.Float float_ = new Ellipse2D.Float(point2.x + n4 / 2 - n / 2, point2.y + n5 / 2 - n / 2, n, n);
            point2.setLocation(point2.x + n4, point2.y + n5);
            return float_;
        }
        if (n2 == 7 || n2 == 8) {
            GeneralPath generalPath = new GeneralPath(1, 4);
            generalPath.moveTo(point2.x + n4 / 2 + n5 / 2, point2.y + n5 / 2 - n4 / 2);
            generalPath.lineTo(point2.x + n4 / 2 - n5 / 2, point2.y + n5 / 2 + n4 / 2);
            if (n2 == 8) {
                generalPath.moveTo(point2.x + n4 / 3 + n5 / 2, point2.y + n5 / 3 - n4 / 2);
                generalPath.lineTo(point2.x + n4 / 3 - n5 / 2, point2.y + n5 / 3 + n4 / 2);
            }
            return generalPath;
        }
        return null;
    }

    public boolean supportsAttribute(Object object) {
        return object.equals(GraphConstants.POINTS) || object.equals("backgroundColor") || object.equals("border") || object.equals("fontName") || object.equals("fontSize") || object.equals("fontStyle") || object.equals("foregroundColor") || object.equals("bordercolor") || object.equals(GraphConstants.LABELPOSITION) || object.equals("lineStyle") || object.equals("linecolor") || object.equals("linewidth") || object.equals("dashPattern") || object.equals("lineBegin") || object.equals("beginSize") || object.equals("beginFill") || object.equals("lineEnd") || object.equals("endsize") || object.equals("endFill") || object.equals("opaque");
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

