/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.JGraph;
import com.jgraph.graph.AbstractCellView;
import com.jgraph.graph.CellHandle;
import com.jgraph.graph.CellMapper;
import com.jgraph.graph.CellView;
import com.jgraph.graph.CellViewRenderer;
import com.jgraph.graph.ConnectionSet;
import com.jgraph.graph.Edge;
import com.jgraph.graph.EdgeRenderer;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.GraphContext;
import com.jgraph.graph.GraphView;
import com.jgraph.graph.Port;
import com.jgraph.graph.PortView;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEdit;

public class EdgeView
extends AbstractCellView {
    public static EdgeRenderer renderer = new EdgeRenderer();
    protected List points;
    protected PortView source;
    protected PortView target;
    protected Point labelPosition;

    public EdgeView(Object object, JGraph jGraph, CellMapper cellMapper) {
        super(object, jGraph, cellMapper);
    }

    public void refresh(boolean bl) {
        super.refresh(bl);
        Object object = this.getModel().getSource(this.cell);
        Object object2 = this.getModel().getTarget(this.cell);
        this.setSource((PortView)this.mapper.getMapping(object, bl));
        this.setTarget((PortView)this.mapper.getMapping(object2, bl));
    }

    public void update() {
        super.update();
        List list = this.points;
        this.points = GraphConstants.getPoints(this.attributes);
        if (this.points == null) {
            this.points = new ArrayList();
            this.points.add(new Point(10, 10));
            this.points.add(new Point(20, 20));
            GraphConstants.setPoints(this.attributes, this.points);
        } else if (list != this.points) {
            this.setSource(this.source);
            this.setTarget(this.target);
        }
        this.labelPosition = GraphConstants.getLabelPosition(this.attributes);
        if (this.labelPosition == null) {
            int n = 500;
            this.labelPosition = new Point(n, n);
            GraphConstants.setLabelPosition(this.attributes, this.labelPosition);
        }
    }

    public boolean intersects(Graphics graphics, Rectangle rectangle) {
        return this.getEdgeRenderer().intersects(graphics, this, rectangle);
    }

    public Rectangle getBounds() {
        return this.getEdgeRenderer().getBounds(this);
    }

    public EdgeRenderer getEdgeRenderer() {
        return (EdgeRenderer)this.getRenderer();
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        return new EdgeHandle(this, graphContext);
    }

    public PortView getSource() {
        return this.source;
    }

    public void setSource(PortView portView) {
        this.source = portView;
        if (this.source != null) {
            this.points.set(0, this.source);
        } else {
            this.points.set(0, this.getPoint(0));
        }
    }

    public PortView getTarget() {
        return this.target;
    }

    public void setTarget(PortView portView) {
        this.target = portView;
        int n = this.points.size() - 1;
        if (this.target != null) {
            this.points.set(n, this.target);
        } else {
            this.points.set(n, this.getPoint(n));
        }
    }

    public Point getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(Point point) {
        this.labelPosition.setLocation(point);
    }

    public int getPointCount() {
        return this.points.size();
    }

    public Point getPoint(int n) {
        Object e = this.points.get(n);
        if (e instanceof PortView) {
            return ((PortView)e).getLocation(this);
        }
        if (e instanceof Point) {
            return (Point)e;
        }
        return null;
    }

    public void setPoint(int n, Point point) {
        this.points.set(n, point);
    }

    public void addPoint(int n, Point point) {
        this.points.add(n, point);
    }

    public void removePoint(int n) {
        this.points.remove(n);
    }

    public boolean isAddPointEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isRightMouseButton(mouseEvent);
    }

    public boolean isRemovePointEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isRightMouseButton(mouseEvent);
    }

    public class EdgeHandle
    implements CellHandle,
    Serializable {
        protected static final transient int NO_INDEX = -2;
        protected static final transient int LABEL_INDEX = -1;
        protected JGraph graph;
        protected EdgeView edge;
        protected transient int index = -2;
        protected transient Rectangle[] r;
        protected transient Rectangle loc;
        protected boolean firstOverlayCall = true;
        protected boolean isEdgeConnectable = true;
        protected EdgeView relevantEdge = null;

        public EdgeHandle(EdgeView edgeView2, GraphContext graphContext) {
            this.graph = graphContext.getGraph();
            this.edge = edgeView2;
            this.loc = new Rectangle();
            EdgeView edgeView3 = (EdgeView)this.graph.getView().getMapping(edgeView2.getCell(), false);
            this.reloadPoints(edgeView3);
            this.isEdgeConnectable = GraphConstants.isConnectable(edgeView2.getAttributes());
        }

        protected void reloadPoints(EdgeView edgeView) {
            this.relevantEdge = edgeView;
            this.r = new Rectangle[edgeView.getPointCount()];
            int n = 0;
            while (n < this.r.length) {
                this.r[n] = new Rectangle();
                ++n;
            }
            this.invalidate();
        }

        public void paint(Graphics graphics) {
            this.invalidate();
            int n = 0;
            while (n < this.r.length) {
                if (this.isEdgeConnectable) {
                    graphics.setColor(this.graph.getHandleColor());
                } else {
                    graphics.setColor(this.graph.getLockedHandleColor());
                }
                graphics.fill3DRect(this.r[n].x, this.r[n].y, this.r[n].width, this.r[n].height, true);
                PortView portView = null;
                if (n == 0 && this.edge.getSource() != null) {
                    portView = this.edge.getSource();
                } else if (n == this.r.length - 1 && this.edge.getTarget() != null) {
                    portView = this.edge.getTarget();
                }
                if (portView != null) {
                    graphics.setColor(this.graph.getLockedHandleColor());
                    Point point = GraphConstants.getOffset(portView.getAttributes());
                    if (point != null) {
                        graphics.drawLine(this.r[n].x + 1, this.r[n].y + 1, this.r[n].x + this.r[n].width - 3, this.r[n].y + this.r[n].height - 3);
                        graphics.drawLine(this.r[n].x + 1, this.r[n].y + this.r[n].height - 3, this.r[n].x + this.r[n].width - 3, this.r[n].y + 1);
                    } else {
                        graphics.drawRect(this.r[n].x + 2, this.r[n].y + 2, this.r[n].width - 5, this.r[n].height - 5);
                    }
                }
                ++n;
            }
        }

        public void overlay(Graphics graphics) {
            if (this.edge != null && !this.firstOverlayCall) {
                graphics.setColor(this.graph.getForeground());
                graphics.setXORMode(this.graph.getBackground());
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.scale(this.graph.getScale(), this.graph.getScale());
                this.graph.getUI().paintCell(graphics, this.edge, this.edge.getBounds(), true);
                graphics2D.setTransform(affineTransform);
                if (this.isSourceEditing()) {
                    this.paintPort(graphics, this.edge.getSource());
                } else if (this.isTargetEditing()) {
                    this.paintPort(graphics, this.edge.getTarget());
                }
            }
            this.firstOverlayCall = false;
        }

        protected void paintPort(Graphics graphics, PortView portView) {
            boolean bl = GraphConstants.getOffset(portView.getAttributes()) != null;
            Rectangle rectangle = bl ? portView.getBounds() : portView.getParentView().getBounds();
            rectangle = this.graph.toScreen(new Rectangle(rectangle));
            int n = 3;
            rectangle.translate(-n, -n);
            rectangle.setSize(rectangle.width + 2 * n, rectangle.height + 2 * n);
            this.graph.getUI().paintCell(graphics, portView, rectangle, true);
        }

        protected boolean isSourceEditing() {
            return this.index == 0 && this.edge.getSource() != null;
        }

        protected boolean snap(boolean bl, Point point) {
            boolean bl2 = this.graph.isConnectable() && this.isEdgeConnectable;
            Port port = this.graph.getPortForLocation(point.x, point.y);
            if (port != null && bl2) {
                PortView portView = (PortView)this.graph.getView().getMapping(port, false);
                Edge edge = (Edge)this.edge.getCell();
                if (bl && this.edge.getSource() != portView && EdgeView.this.getModel().acceptsSource(edge, port)) {
                    this.overlay(this.graph.getGraphics());
                    this.edge.setSource(portView);
                    this.overlay(this.graph.getGraphics());
                } else if (!bl && this.edge.getTarget() != portView && EdgeView.this.getModel().acceptsTarget(edge, port)) {
                    this.overlay(this.graph.getGraphics());
                    this.edge.setTarget(portView);
                    this.overlay(this.graph.getGraphics());
                }
                return portView != null;
            }
            return false;
        }

        protected boolean isTargetEditing() {
            return this.index == this.edge.getPointCount() - 1 && this.edge.getTarget() != null;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = 0;
            while (n < this.r.length) {
                if (this.r[n].contains(mouseEvent.getPoint())) {
                    this.graph.setCursor(new Cursor(1));
                    mouseEvent.consume();
                    return;
                }
                ++n;
            }
            if (this.loc.contains(mouseEvent.getPoint())) {
                this.graph.setCursor(new Cursor(12));
                mouseEvent.consume();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl = this.graph.isBendable() && GraphConstants.isBendable(this.edge.getAttributes());
            this.index = -2;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.graph.getHandleSize();
            Rectangle rectangle = this.graph.fromScreen(new Rectangle(n - n3, n2 - n3, 2 * n3, 2 * n3));
            int n4 = 0;
            while (n4 < this.r.length && this.index == -2) {
                if (this.r[n4].contains(n, n2)) {
                    this.index = n4;
                }
                ++n4;
            }
            if (this.index == -2 && this.loc != null && this.loc.contains(n, n2) && !EdgeView.this.isAddPointEvent(mouseEvent) && !EdgeView.this.isRemovePointEvent(mouseEvent)) {
                if (mouseEvent.getClickCount() == this.graph.getEditClickCount()) {
                    this.graph.startEditingAtCell(this.edge);
                } else {
                    this.index = -1;
                }
            }
            if (this.isSourceEditing() && this.edge.getSource() != null || this.isTargetEditing() && this.edge.getTarget() != null) {
                if (!this.graph.isDisconnectable() || !GraphConstants.isDisconnectable(this.edge.getAttributes())) {
                    this.index = -2;
                }
            } else if (this.index > 0 && this.index < this.r.length - 1 && EdgeView.this.isRemovePointEvent(mouseEvent)) {
                if (bl) {
                    this.edge.removePoint(this.index);
                    this.mouseReleased(mouseEvent);
                }
            } else if (this.index == -2 && EdgeView.this.isAddPointEvent(mouseEvent)) {
                if (bl && this.edge.intersects(this.graph.getGraphics(), rectangle)) {
                    Point point = this.graph.snap(new Point(mouseEvent.getPoint()));
                    double d = Double.MAX_VALUE;
                    double d2 = 0.0;
                    int n5 = 0;
                    while (n5 < this.edge.getPointCount() - 1) {
                        Point point2;
                        Point point3 = this.edge.getPoint(n5);
                        d2 = new Line2D.Double(point3, point2 = this.edge.getPoint(n5 + 1)).ptLineDistSq(point);
                        if (d2 < d) {
                            d = d2;
                            this.index = n5 + 1;
                        }
                        ++n5;
                    }
                    if (this.index != -2) {
                        this.edge.addPoint(this.index, point);
                        this.reloadPoints(this.edge);
                        this.paint(this.graph.getGraphics());
                    }
                }
            } else if (!bl) {
                this.index = -2;
            }
            if (this.index != -2) {
                mouseEvent.consume();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = this.graph.fromScreen(new Point(mouseEvent.getPoint()));
            if (this.index == -1) {
                Rectangle rectangle = this.edge.getBounds();
                if (rectangle != null) {
                    int n = point.x - rectangle.x;
                    int n2 = point.y - rectangle.y;
                    int n3 = 1;
                    if (rectangle.width != 0) {
                        n3 = 1000 / rectangle.width;
                    }
                    int n4 = 1;
                    if (rectangle.height != 0) {
                        n4 = 1000 / rectangle.height;
                    }
                    point = new Point(n * n3, n2 * n4);
                    this.overlay(this.graph.getGraphics());
                    this.edge.setLabelPosition(point);
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
            } else if (this.index != -2) {
                boolean bl;
                boolean bl2 = this.index == 0;
                boolean bl3 = bl = this.index == this.r.length - 1;
                if (!(bl2 && this.snap(true, point) || bl && this.snap(false, point) || !(bl2 && EdgeView.this.getModel().acceptsSource(EdgeView.this.cell, null) || bl && EdgeView.this.getModel().acceptsTarget(EdgeView.this.cell, null)) && (bl2 || bl))) {
                    this.overlay(this.graph.getGraphics());
                    point = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                    this.edge.setPoint(this.index, point);
                    if (bl2) {
                        this.edge.setSource(null);
                    } else if (bl) {
                        this.edge.setTarget(null);
                    }
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object;
            Object object2;
            Object[] objectArray = new CellView[]{this.edge};
            ConnectionSet connectionSet = new ConnectionSet();
            if (this.edge.getCell() instanceof Edge) {
                object2 = (Edge)this.edge.getCell();
                object = null;
                Port port = null;
                if (this.edge.getSource() != null) {
                    object = (Port)this.edge.getSource().getCell();
                }
                if (this.edge.getTarget() != null) {
                    port = (Port)this.edge.getTarget().getCell();
                }
                if (object != EdgeView.this.getModel().getSource(object2)) {
                    connectionSet.connect(object2, object, true);
                }
                if (port != EdgeView.this.getModel().getTarget(object2)) {
                    connectionSet.connect(object2, (Object)port, false);
                }
            }
            if (!EdgeView.this.getModel().isAttributeStore()) {
                object2 = GraphConstants.createAttributeMap((CellView[])objectArray, this.graph.getView());
                object = this.graph.getView().createEdit((Map)object2);
                EdgeView.this.getModel().edit(connectionSet, null, null, new UndoableEdit[]{object});
                ((GraphView.GraphViewEdit)object).execute();
            } else {
                object2 = GraphConstants.createPropertyMap(objectArray, null);
                EdgeView.this.getModel().edit(connectionSet, (Map)object2, null, null);
            }
            mouseEvent.consume();
        }

        protected void invalidate() {
            EdgeView edgeView = this.relevantEdge;
            int n = this.graph.getHandleSize();
            EdgeRenderer edgeRenderer = renderer;
            int n2 = 0;
            while (n2 < this.r.length) {
                Point point = this.graph.toScreen(new Point(edgeView.getPoint(n2)));
                this.r[n2].setBounds(point.x - n, point.y - n, 2 * n, 2 * n);
                point = this.graph.toScreen(edgeRenderer.getLabelPosition(edgeView));
                Dimension dimension = edgeRenderer.getLabelSize(edgeView);
                if (point != null && dimension != null) {
                    Point point2 = this.graph.toScreen(new Point(dimension.width, dimension.height));
                    this.loc.setBounds(point.x - point2.x / 2, point.y - point2.y / 2, point2.x, point2.y);
                }
                ++n2;
            }
        }
    }
}

