/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.JGraph;
import com.jgraph.graph.CellMapper;
import com.jgraph.graph.CellView;
import com.jgraph.graph.ConnectionSet;
import com.jgraph.graph.DefaultGraphModel;
import com.jgraph.graph.EdgeView;
import com.jgraph.graph.GraphView;
import com.jgraph.graph.Port;
import com.jgraph.graph.PortView;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GraphContext
implements CellMapper {
    protected JGraph graph;
    protected transient GraphView graphView;
    protected Object[] cells;
    protected Set cellSet;
    protected int cellCount;
    protected Map views = new Hashtable();

    public GraphContext(JGraph jGraph, Object[] objectArray) {
        this.cellSet = DefaultGraphModel.getDescendants(jGraph.getModel(), objectArray);
        this.graphView = jGraph.getView();
        this.graph = jGraph;
        this.cells = objectArray;
        Iterator iterator = this.cellSet.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Port) continue;
            ++this.cellCount;
        }
    }

    public boolean isEmpty() {
        return this.cells == null || this.cells.length == 0;
    }

    public int getDescendantCount() {
        return this.cellCount;
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public boolean contains(Object object) {
        return this.cellSet.contains(object);
    }

    public CellView[] createTemporaryCellViews() {
        CellView[] cellViewArray = new CellView[this.cells.length];
        int n = 0;
        while (n < this.cells.length) {
            cellViewArray[n] = this.getMapping(this.cells[n], true);
            ++n;
        }
        return cellViewArray;
    }

    public PortView[] createTemporaryPortViews() {
        Object object;
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Iterator iterator = this.cellSet.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof Port)) continue;
            arrayList.add(this.getMapping(object, true));
        }
        object = new PortView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public CellView[] createTemporaryContextViews() {
        return this.createTemporaryContextViews(this.cellSet);
    }

    public CellView[] createTemporaryContextViews(Set set) {
        Object object;
        Object[] objectArray = set.toArray();
        Set set2 = DefaultGraphModel.getEdges(this.graph.getModel(), objectArray);
        ArrayList<EdgeView> arrayList = new ArrayList<EdgeView>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (set.contains(object)) continue;
            arrayList.add((EdgeView)this.getMapping(object, true));
        }
        object = new CellView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public CellView getMapping(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        boolean bl2 = this.contains(object);
        if (bl2 || bl) {
            CellView cellView = (CellView)this.views.get(object);
            if (cellView == null && bl) {
                cellView = this.graphView.getFactory().createView(object, this);
                CellView cellView2 = this.graphView.getMapping(object, false);
                if (cellView2 != null) {
                    cellView.setAttributes(cellView2.getAttributes());
                    cellView.refresh(false);
                    cellView.update();
                }
            }
            return cellView;
        }
        return this.graphView.getMapping(object, false);
    }

    public ConnectionSet disconnect(CellView[] cellViewArray) {
        ConnectionSet connectionSet = new ConnectionSet();
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n] instanceof EdgeView) {
                EdgeView edgeView = (EdgeView)cellViewArray[n];
                PortView portView = edgeView.getSource();
                if (portView != null && !this.contains(portView.getCell())) {
                    edgeView.setSource(null);
                    connectionSet.disconnect(edgeView.getCell(), true);
                }
                if ((portView = edgeView.getTarget()) != null && !this.contains(portView.getCell())) {
                    edgeView.setTarget(null);
                    connectionSet.disconnect(edgeView.getCell(), false);
                }
            }
            ++n;
        }
        return connectionSet;
    }

    public void putMapping(Object object, CellView cellView) {
        this.views.put(object, cellView);
    }
}

