/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.graph.ConnectionSet;
import com.jgraph.graph.DefaultGraphCell;
import com.jgraph.plaf.basic.BasicTransferable;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import java.util.Map;

public class GraphTransferable
extends BasicTransferable
implements Serializable,
ClipboardOwner {
    public static DataFlavor dataFlavor;
    protected Object[] cells;
    protected ConnectionSet cs;
    protected Map attributeMap;
    protected Rectangle bounds;

    public GraphTransferable(Object[] objectArray, ConnectionSet connectionSet, Map map, Rectangle rectangle) {
        this.attributeMap = map;
        this.bounds = rectangle;
        this.cells = objectArray;
        this.cs = connectionSet;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public ConnectionSet getConnectionSet() {
        return this.cs;
    }

    public Map getAttributeMap() {
        return this.attributeMap;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public DataFlavor[] getRicherFlavors() {
        return new DataFlavor[]{dataFlavor};
    }

    public Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (dataFlavor.equals(GraphTransferable.dataFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public boolean isPlainSupported() {
        return this.cells != null && this.cells.length == 1;
    }

    public String getPlainData() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cells[0] instanceof DefaultGraphCell && (object = ((DefaultGraphCell)this.cells[0]).getUserObject()) != null) {
            return object.toString();
        }
        return this.cells[0].toString();
    }

    public boolean isHTMLSupported() {
        return this.isPlainSupported();
    }

    public String getHTMLData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body><p>");
        stringBuffer.append(this.getPlainData());
        stringBuffer.append("</p></body></html>");
        return stringBuffer.toString();
    }

    static {
        DataFlavor dataFlavor;
        try {
            dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=com.jgraph.graph.GraphTransferable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            dataFlavor = null;
        }
        GraphTransferable.dataFlavor = dataFlavor;
    }
}

