/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.event.GraphModelEvent;
import com.jgraph.graph.AbstractCellView;
import com.jgraph.graph.CellMapper;
import com.jgraph.graph.CellView;
import com.jgraph.graph.CellViewFactory;
import com.jgraph.graph.DefaultGraphModel;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.GraphModel;
import com.jgraph.graph.Port;
import com.jgraph.graph.PortView;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.Stack;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class GraphView
extends Observable
implements CellMapper,
Serializable {
    protected GraphModel graphModel;
    protected Map mapping = new Hashtable();
    protected CellMapper mapper;
    protected CellViewFactory factory = null;
    protected List roots = new ArrayList();
    protected PortView[] ports;

    public GraphView(GraphModel graphModel, CellViewFactory cellViewFactory) {
        this.factory = cellViewFactory;
        this.setModel(graphModel);
    }

    public void setFactory(CellViewFactory cellViewFactory) {
        this.factory = cellViewFactory;
    }

    public CellViewFactory getFactory() {
        return this.factory;
    }

    public void setModel(GraphModel graphModel) {
        this.roots.clear();
        this.mapping.clear();
        this.graphModel = graphModel;
        Object[] objectArray = DefaultGraphModel.getRoots(graphModel);
        this.insertRoots(this.getMapping(objectArray, true));
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.factory.updateAutoSize(this.getMapping(objectArray[n], false));
                ++n;
            }
        }
        this.updatePorts();
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public CellView[] getRoots() {
        CellView[] cellViewArray = new CellView[this.roots.size()];
        this.roots.toArray(cellViewArray);
        return cellViewArray;
    }

    public CellView[] getRoots(Rectangle rectangle) {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        CellView[] cellViewArray = this.getRoots();
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n].getBounds().intersects(rectangle)) {
                arrayList.add(cellViewArray[n]);
            }
            ++n;
        }
        cellViewArray = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray);
        return cellViewArray;
    }

    public PortView[] getPorts() {
        return this.ports;
    }

    protected void updatePorts() {
        Object[] objectArray = DefaultGraphModel.getRoots(this.graphModel);
        Set set = DefaultGraphModel.getDescendants(this.graphModel, objectArray);
        if (set != null) {
            Object[] objectArray2 = set.toArray();
            ArrayList<CellView> arrayList = new ArrayList<CellView>();
            int n = 0;
            while (n < objectArray2.length) {
                if (objectArray2[n] instanceof Port) {
                    CellView cellView = this.getMapping(objectArray2[n], false);
                    arrayList.add(cellView);
                    this.refreshAndUpdate(cellView, false, false);
                }
                ++n;
            }
            this.ports = new PortView[arrayList.size()];
            arrayList.toArray(this.ports);
        }
    }

    protected void refreshAndUpdate(CellView cellView, boolean bl, boolean bl2) {
        if (cellView != null) {
            cellView.refresh(bl);
            cellView.update();
            if (bl2) {
                CellView[] cellViewArray = cellView.getChildViews();
                int n = 0;
                while (n < cellViewArray.length) {
                    this.refreshAndUpdate(cellViewArray[n], bl, bl2);
                    ++n;
                }
            }
        }
    }

    public void graphChanged(GraphModelEvent.GraphModelChange graphModelChange) {
        Object object;
        CellView[] cellViewArray = graphModelChange.getViews(this);
        if (cellViewArray != null) {
            int n = 0;
            while (n < cellViewArray.length) {
                if (cellViewArray[n] != null) {
                    this.putMapping(cellViewArray[n].getCell(), cellViewArray[n]);
                }
                ++n;
            }
        }
        Object[] objectArray = this.order(graphModelChange.getChanged());
        CellView[] cellViewArray2 = this.getMapping(graphModelChange.getInserted(), true);
        cellViewArray = this.removeRoots(graphModelChange.getRemoved());
        graphModelChange.putViews(this, cellViewArray);
        this.insertRoots(cellViewArray2);
        this.setAttributesWithModelKeys(graphModelChange.getAttributeMap());
        if (objectArray != null && objectArray.length > 0) {
            if (this.graphModel.isOrdered()) {
                this.roots.clear();
                Object[] objectArray2 = DefaultGraphModel.getRoots(this.graphModel);
                object = this.getMapping(objectArray2);
                int n = 0;
                while (n < ((Object[])object).length) {
                    this.roots.add(object[n]);
                    this.refreshAndUpdate((CellView)object[n], true, false);
                    this.factory.updateAutoSize((CellView)object[n]);
                    ++n;
                }
            }
            int n = 0;
            while (n < objectArray.length) {
                object = this.getMapping(objectArray[n], true);
                if (object != null) {
                    this.refreshAndUpdate((CellView)object, true, false);
                    this.factory.updateAutoSize((CellView)object);
                    if (!this.graphModel.isOrdered()) {
                        Object object2 = this.graphModel.getParent(objectArray[n]);
                        boolean bl = this.roots.contains(object);
                        if (object2 == null && !bl) {
                            this.roots.add(object);
                        } else if (object2 != null && bl) {
                            this.roots.remove(object);
                        }
                    }
                }
                ++n;
            }
        }
        Object[] objectArray3 = graphModelChange.getRemoved();
        object = graphModelChange.getInserted();
        if (objectArray3 != null && objectArray3.length > 0 || object != null && ((Object[])object).length > 0 || this.graphModel.isOrdered()) {
            this.updatePorts();
        }
    }

    protected void setAttributesWithModelKeys(Map map) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getKey() == null || !(entry.getValue() instanceof Map)) continue;
                CellView cellView = this.getMapping(entry.getKey(), false);
                if (cellView != null) {
                    cellView.setAttributes((Map)entry.getValue());
                }
                this.factory.updateAutoSize(cellView);
            }
        }
    }

    public void insertRoots(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            int n = 0;
            while (n < cellViewArray.length) {
                Object object = this.graphModel.getParent(cellViewArray[n].getCell());
                if (!this.roots.contains(cellViewArray[n]) && object == null) {
                    this.roots.add(cellViewArray[n]);
                }
                this.refreshAndUpdate(cellViewArray[n], true, true);
                ++n;
            }
        }
    }

    public CellView[] removeRoots(Object[] objectArray) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                cellViewArray[n] = this.removeMapping(objectArray[n]);
                if (cellViewArray[n] != null) {
                    cellViewArray[n].removeFromParent();
                    this.roots.remove(cellViewArray[n]);
                }
                ++n;
            }
            return cellViewArray;
        }
        return null;
    }

    public CellView getMapping(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        CellView cellView = (CellView)this.mapping.get(object);
        if (cellView == null && bl) {
            cellView = this.factory.createView(object, this);
        }
        return cellView;
    }

    public CellView[] getMapping(Object[] objectArray) {
        return this.getMapping(objectArray, false);
    }

    public CellView[] getMapping(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                cellViewArray[n] = this.getMapping(objectArray[n], bl);
                ++n;
            }
            return cellViewArray;
        }
        return null;
    }

    public void putMapping(Object object, CellView cellView) {
        if (object != null && cellView != null) {
            this.mapping.put(object, cellView);
        }
    }

    public CellView removeMapping(Object object) {
        if (object != null) {
            CellView cellView = (CellView)this.mapping.remove(object);
            return cellView;
        }
        return null;
    }

    public void edit(Map map) {
        if (!map.isEmpty()) {
            GraphViewEdit graphViewEdit = this.createEdit(map);
            graphViewEdit.execute();
            this.graphModel.edit(null, null, null, new UndoableEdit[]{graphViewEdit});
        }
    }

    public GraphViewEdit createEdit(Map map) {
        GraphViewEdit graphViewEdit = new GraphViewEdit(map);
        graphViewEdit.end();
        return graphViewEdit;
    }

    public void toBack(CellView[] cellViewArray) {
        if (this.graphModel.isOrdered()) {
            this.graphModel.toBack(this.getCells(cellViewArray));
        } else {
            GraphViewLayerEdit graphViewLayerEdit = new GraphViewLayerEdit(this, cellViewArray, -2);
            graphViewLayerEdit.execute();
            this.graphModel.edit(null, null, null, new UndoableEdit[]{graphViewLayerEdit});
        }
    }

    public void toFront(CellView[] cellViewArray) {
        if (this.graphModel.isOrdered()) {
            this.graphModel.toFront(this.getCells(cellViewArray));
        } else {
            GraphViewLayerEdit graphViewLayerEdit = new GraphViewLayerEdit(this, cellViewArray, -1);
            graphViewLayerEdit.execute();
            this.graphModel.edit(null, null, null, new UndoableEdit[]{graphViewLayerEdit});
        }
    }

    public Object[] getCells(CellView[] cellViewArray) {
        Object[] objectArray = new Object[cellViewArray.length];
        int n = 0;
        while (n < cellViewArray.length) {
            objectArray[n] = cellViewArray[n].getCell();
            ++n;
        }
        return objectArray;
    }

    public Object[] order(Object[] objectArray) {
        if (objectArray != null) {
            if (this.graphModel != null && !this.graphModel.isOrdered()) {
                Object[] objectArray2;
                HashSet<Object> hashSet = new HashSet<Object>();
                int n = 0;
                while (n < objectArray.length) {
                    hashSet.add(objectArray[n]);
                    ++n;
                }
                CellView[] cellViewArray = this.getRoots();
                Stack<Object> stack = new Stack<Object>();
                int n2 = 0;
                while (n2 < cellViewArray.length) {
                    stack.add(cellViewArray[n2]);
                    ++n2;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (!stack.isEmpty()) {
                    CellView cellView = (CellView)stack.pop();
                    if (hashSet.contains(cellView.getCell())) {
                        arrayList.add(cellView.getCell());
                    }
                    objectArray2 = cellView.getChildViews();
                    int n3 = 0;
                    while (n3 < objectArray2.length) {
                        stack.add(objectArray2[n3]);
                        ++n3;
                    }
                }
                int n4 = arrayList.size();
                objectArray2 = new Object[n4];
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    objectArray2[--n4] = iterator.next();
                }
                return objectArray2;
            }
            Object[] objectArray3 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray3[objectArray.length - n - 1] = objectArray[n];
                ++n;
            }
            return objectArray3;
        }
        return objectArray;
    }

    public static void translateViews(CellView[] cellViewArray, int n, int n2) {
        cellViewArray = AbstractCellView.getDescendantViews(cellViewArray);
        int n3 = 0;
        while (n3 < cellViewArray.length) {
            GraphConstants.translate(cellViewArray[n3].getAttributes(), n, n2);
            ++n3;
        }
    }

    public CellView[] getAllDescendants(CellView[] cellViewArray) {
        Object object;
        Stack<CellView> stack = new Stack<CellView>();
        int n = 0;
        while (n < cellViewArray.length) {
            stack.add(cellViewArray[n]);
            ++n;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!stack.isEmpty()) {
            object = (CellView)stack.pop();
            CellView[] cellViewArray2 = object.getChildViews();
            int n2 = 0;
            while (n2 < cellViewArray2.length) {
                stack.add(cellViewArray2[n2]);
                ++n2;
            }
            arrayList.add(object);
            int n3 = 0;
            while (n3 < this.graphModel.getChildCount(object.getCell())) {
                Object object2 = this.graphModel.getChild(object.getCell(), n3);
                if (object2 instanceof Port) {
                    stack.add(this.getMapping(object2, false));
                }
                ++n3;
            }
        }
        object = new CellView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public static class GraphViewLayerEdit
    extends AbstractUndoableEdit
    implements GraphModelEvent.GraphViewChange {
        public static final int FRONT = -1;
        public static final int BACK = -2;
        protected Object changeSource;
        protected transient Object[] cells;
        protected transient int[] next;
        protected transient int[] prev;
        protected int layer;

        public GraphViewLayerEdit(Object object, Object[] objectArray, int n) {
            this.changeSource = object;
            this.cells = objectArray;
            this.layer = n;
            this.next = new int[objectArray.length];
            this.prev = new int[objectArray.length];
            this.updateNext();
        }

        protected void updateNext() {
            int n = 0;
            while (n < this.next.length) {
                this.next[n] = this.layer;
                ++n;
            }
        }

        public Object getSource() {
            return this.changeSource;
        }

        public Object[] getChanged() {
            return this.cells;
        }

        public Object[] getContext() {
            return null;
        }

        public Map getAttributeMap() {
            return null;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.updateNext();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        protected void execute() {
            int n = 0;
            while (n < this.cells.length) {
                List list = this.getParentList(this.cells[n]);
                this.prev[n] = list.indexOf(this.cells[n]);
                if (this.prev[n] >= 0) {
                    list.remove(this.prev[n]);
                    int n2 = this.next[n];
                    if (n2 == -1) {
                        n2 = list.size();
                    } else if (n2 == -2) {
                        n2 = 0;
                    }
                    list.add(n2, this.cells[n]);
                    this.next[n] = this.prev[n];
                }
                ++n;
            }
            this.updateListeners();
        }

        protected void updateListeners() {
            GraphView.super.setChanged();
            ((GraphView)this.changeSource).notifyObservers(this);
        }

        protected List getParentList(Object object) {
            CellView cellView = ((CellView)object).getParentView();
            List list = null;
            if (cellView == null) {
                list = ((GraphView)this.changeSource).roots;
            } else if (cellView instanceof AbstractCellView) {
                list = ((AbstractCellView)cellView).childViews;
            }
            return list;
        }
    }

    public class GraphViewEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphViewChange {
        protected Object[] cells;
        protected CellView[] context;
        protected Map attributeMap;

        public GraphViewEdit(Map map) {
            this.attributeMap = map;
            this.cells = this.attributeMap.keySet().toArray();
            int n = 0;
            while (n < this.cells.length) {
                if (this.cells[n] instanceof CellView) {
                    this.cells[n] = ((CellView)this.cells[n]).getCell();
                }
                ++n;
            }
            Set set = DefaultGraphModel.getEdges(GraphView.this.getModel(), this.cells);
            Object[] objectArray = set.toArray();
            this.context = new CellView[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.context[n2] = GraphView.this.getMapping(objectArray[n2], false);
                ++n2;
            }
        }

        public boolean isSignificant() {
            return true;
        }

        public Object getSource() {
            return GraphView.this;
        }

        public Object[] getChanged() {
            return this.attributeMap.keySet().toArray();
        }

        public Object[] getContext() {
            return this.context;
        }

        public Map getAttributeMap() {
            return this.attributeMap;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            if (this.attributeMap != null) {
                Hashtable<CellView, Map> hashtable = new Hashtable<CellView, Map>();
                Iterator iterator = this.attributeMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!(entry.getKey() instanceof CellView)) continue;
                    CellView cellView = (CellView)entry.getKey();
                    Map map = GraphConstants.cloneMap(cellView.getAttributes());
                    GraphConstants.setRemoveAll(map, true);
                    hashtable.put(cellView, map);
                    Map map2 = (Map)entry.getValue();
                    cellView.setAttributes(map2);
                    cellView.refresh(false);
                    cellView.update();
                    GraphView.this.factory.updateAutoSize(cellView);
                }
                this.attributeMap = hashtable;
                int n = 0;
                while (n < this.context.length) {
                    this.context[n].update();
                    ++n;
                }
                GraphView.super.setChanged();
                GraphView.this.notifyObservers(this);
            }
        }
    }
}

