/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.graph.GraphModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;

public class ParentMap
implements Serializable {
    protected ArrayList entries = new ArrayList();
    protected Set nodes = new HashSet();
    protected Map childCount = new Hashtable();

    public static ParentMap create(GraphModel graphModel, Object[] objectArray, boolean bl) {
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        while (n < objectArray.length) {
            hashSet.add(objectArray[n]);
            ++n;
        }
        ParentMap parentMap = new ParentMap();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = graphModel.getParent(objectArray[n2]);
            if (object != null && !hashSet.contains(object)) {
                parentMap.addEntry(objectArray[n2], bl ? null : object);
            }
            if (bl) {
                while (hashSet.contains(object)) {
                    object = graphModel.getParent(object);
                }
                int n3 = 0;
                while (n3 < graphModel.getChildCount(objectArray[n2])) {
                    Object object2 = graphModel.getChild(objectArray[n2], n3);
                    if (!hashSet.contains(object2)) {
                        parentMap.addEntry(object2, object);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return parentMap;
    }

    public void addEntry(Object object, Object object2) {
        if (object != null) {
            TreeNode treeNode = null;
            if (object instanceof TreeNode) {
                treeNode = ((TreeNode)object).getParent();
                this.changeChildCount(treeNode, -1);
                if (treeNode != null) {
                    this.nodes.add(treeNode);
                }
            }
            this.entries.add(new Entry(object, object2));
            this.changeChildCount(object2, 1);
            this.nodes.add(object);
            if (object2 != null) {
                this.nodes.add(object2);
            }
        }
    }

    protected void changeChildCount(Object object, int n) {
        if (object != null) {
            Integer n2 = (Integer)this.childCount.get(object);
            if (n2 == null) {
                n2 = object instanceof TreeNode ? new Integer(((TreeNode)object).getChildCount()) : new Integer(0);
            }
            int n3 = n2 + n;
            this.childCount.put(object, new Integer(n3));
        }
    }

    public Object[] emptyParents() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.childCount.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getValue() instanceof Integer) || (Integer)entry.getValue() != 0) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray();
    }

    public int size() {
        return this.entries.size();
    }

    public Iterator entries() {
        return this.entries.iterator();
    }

    public Set getChangedNodes() {
        return this.nodes;
    }

    public String toString() {
        String string = super.toString() + "\n";
        Iterator iterator = this.entries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            string = string + " child=" + entry.getChild() + " parent=" + entry.getParent() + "\n";
        }
        return string;
    }

    public class Entry
    implements Serializable {
        protected Object child;
        protected Object parent;

        public Entry(Object object, Object object2) {
            this.child = object;
            this.parent = object2;
        }

        public Object getChild() {
            return this.child;
        }

        public Object getParent() {
            return this.parent;
        }
    }
}

