/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.JGraph;
import com.jgraph.graph.CellView;
import com.jgraph.graph.CellViewRenderer;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.PortView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class PortRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient JGraph graph;
    protected transient PortView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;

    public PortRenderer() {
        this.setForeground(UIManager.getColor("MenuItem.selectionBackground"));
        this.setBackground(UIManager.getColor("Tree.selectionBorderColor"));
    }

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof PortView && jGraph != null) {
            this.graph = jGraph;
            this.view = (PortView)cellView;
            this.hasFocus = this.hasFocus;
            this.selected = bl;
            this.preview = bl3;
            return this;
        }
        return null;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.graph.getBackground());
        graphics.setXORMode(this.graph.getBackground());
        if (this.preview) {
            graphics.setColor(this.getBackground());
            graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
            graphics.drawRect(2, 2, dimension.width - 5, dimension.height - 5);
        }
        boolean bl = GraphConstants.getOffset(this.view.getAttributes()) != null;
        Color color = GraphConstants.getForeground(this.view.getAttributes());
        graphics.setColor(this.getForeground());
        if (bl) {
            graphics.drawLine(2, 2, dimension.width - 2, dimension.height - 2);
            graphics.drawLine(2, dimension.width - 2, dimension.height - 2, 2);
        } else if (!this.preview) {
            graphics.drawRect(3, 3, dimension.width - 4, dimension.height - 4);
        }
    }

    public boolean supportsAttribute(Object object) {
        return object.equals(GraphConstants.OFFSET) || object.equals(GraphConstants.ABSOLUTE);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

