/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.graph;

import com.jgraph.JGraph;
import com.jgraph.graph.CellView;
import com.jgraph.graph.CellViewRenderer;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.VertexView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class VertexRenderer
extends JLabel
implements CellViewRenderer,
Serializable {
    protected transient JGraph graph;
    protected transient VertexView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color bordercolor;
    protected transient int borderWidth;

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof VertexView) {
            this.view = (VertexView)cellView;
            this.setComponentOrientation(jGraph.getComponentOrientation());
            if (jGraph.getEditingCell() != cellView.getCell()) {
                String string = jGraph.convertValueToString(cellView.getCell());
                if (string != null) {
                    this.setText(string.toString());
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
            this.graph = jGraph;
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            if (this.view.isLeaf()) {
                this.installAttributes(cellView);
            } else {
                this.setText(null);
                this.setBorder(null);
                this.setOpaque(false);
                this.setIcon(null);
            }
            return this;
        }
        return null;
    }

    protected void installAttributes(CellView cellView) {
        Color color;
        Map map = cellView.getAttributes();
        this.setIcon(GraphConstants.getIcon(map));
        this.setOpaque(GraphConstants.isOpaque(map));
        this.setBorder(GraphConstants.getBorder(map));
        this.setVerticalAlignment(GraphConstants.getVerticalAlignment(map));
        this.setHorizontalAlignment(GraphConstants.getHorizontalAlignment(map));
        this.setVerticalTextPosition(GraphConstants.getVerticalTextPosition(map));
        this.setHorizontalTextPosition(GraphConstants.getHorizontalTextPosition(map));
        this.bordercolor = GraphConstants.getBorderColor(map);
        this.borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((color = GraphConstants.getForeground(map)) != null ? color : this.defaultForeground);
        Color color2 = GraphConstants.getBackground(map);
        this.setBackground(color2 != null ? color2 : this.defaultBackground);
        this.setFont(GraphConstants.getFont(map));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.selected || this.hasFocus) {
            ((Graphics2D)graphics).setStroke(GraphConstants.SELECTION_STROKE);
            if (this.hasFocus) {
                graphics.setColor(this.graph.getGridColor());
            } else if (this.selected) {
                graphics.setColor(this.graph.getHighlightColor());
            }
            Dimension dimension = this.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public boolean supportsAttribute(Object object) {
        return object.equals(GraphConstants.BOUNDS) || object.equals("backgroundColor") || object.equals("border") || object.equals("fontName") || object.equals("fontSize") || object.equals("fontStyle") || object.equals("foregroundColor") || object.equals("horizontalAlignment") || object.equals("horizontalTextPosition") || object.equals("verticalAlignment") || object.equals("verticalTextPosition") || object.equals("icon") || object.equals("bordercolor") || object.equals("linewidth") || object.equals("opaque");
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

