/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.Attlist;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.EntityDecl;
import com.ibm.xml.parser.GeneralReference;
import com.ibm.xml.parser.NOOPVisitor;
import com.ibm.xml.parser.PseudoNode;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXComment;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXNotation;
import com.ibm.xml.parser.TXPI;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.ToNextSiblingTraversalException;
import com.ibm.xml.parser.Util;
import com.ibm.xml.parser.Visitor;
import com.ibm.xml.parser.XMLChar;
import java.io.Writer;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Node;

public class ToXMLStringVisitor
extends NOOPVisitor
implements Visitor {
    protected Writer writer;
    protected String encoding;
    protected boolean isPrintNonSpecifiedAttributes = true;

    public ToXMLStringVisitor(Writer writer, String string) {
        this.writer = writer;
        this.encoding = string;
    }

    public ToXMLStringVisitor(Writer writer) {
        this(writer, null);
    }

    public void setPrintNonSpecifiedAttributes(boolean bl) {
        this.isPrintNonSpecifiedAttributes = bl;
    }

    public boolean getPrintNonSpecifiedAttributes() {
        return this.isPrintNonSpecifiedAttributes;
    }

    public void visitDocumentPre(TXDocument tXDocument) throws Exception {
        if (tXDocument.getVersion() != null) {
            this.writer.write("<?xml version=\"" + tXDocument.getVersion() + "\"");
            if (tXDocument.getEncoding() != null) {
                this.writer.write(" encoding=\"" + tXDocument.getEncoding() + "\"");
            }
            if (tXDocument.getStandalone() != null) {
                this.writer.write(" standalone=\"" + tXDocument.getStandalone() + "\"");
            }
            this.writer.write("?>");
        }
    }

    public void visitDocumentPost(TXDocument tXDocument) throws Exception {
        this.writer.flush();
    }

    public void visitElementPre(TXElement tXElement) throws Exception {
        this.writer.write("<" + tXElement.getTagName());
        TXAttribute[] tXAttributeArray = tXElement.getAttributeArray();
        int n = 0;
        while (n < tXAttributeArray.length) {
            try {
                TXAttribute tXAttribute = tXAttributeArray[n];
                if (this.isPrintNonSpecifiedAttributes || tXAttribute.getSpecified()) {
                    this.visitAttributePre(tXAttribute);
                }
            }
            catch (ToNextSiblingTraversalException toNextSiblingTraversalException) {}
            ++n;
        }
        if (tXElement.hasChildNodes()) {
            this.writer.write(">");
            return;
        }
        this.writer.write("/>");
    }

    public void visitElementPost(TXElement tXElement) throws Exception {
        if (tXElement.hasChildNodes()) {
            this.writer.write("</" + tXElement.getTagName() + ">");
        }
    }

    public void visitAttributePre(TXAttribute tXAttribute) throws Exception {
        this.writer.write(" ");
        this.writer.write(tXAttribute.getName());
        this.writer.write("=\"");
        Node node = tXAttribute.getFirstChild();
        while (node != null) {
            short s = node.getNodeType();
            if (s == 3) {
                this.writer.write(Util.backReference(node.getNodeValue(), "<&\"", this.encoding));
            } else if (s == 5) {
                this.writer.write("&");
                this.writer.write(node.getNodeName());
                this.writer.write(";");
            }
            node = node.getNextSibling();
        }
        this.writer.write("\"");
        throw new ToNextSiblingTraversalException();
    }

    public void visitPIPre(TXPI tXPI) throws Exception {
        this.writer.write("<?" + tXPI.getNodeName());
        String string = tXPI.getData();
        if (tXPI.getData().length() > 0 && !XMLChar.isSpace(string.charAt(0))) {
            this.writer.write(" ");
        }
        this.writer.write(String.valueOf(tXPI.getData()) + "?>");
    }

    public void visitCommentPre(TXComment tXComment) throws Exception {
        this.writer.write("<!--" + tXComment.getData() + "-->");
    }

    public void visitTextPre(TXText tXText) throws Exception {
        if (tXText instanceof CDATASection) {
            this.writer.write("<![CDATA[" + tXText.getData() + "]]>");
            return;
        }
        this.writer.write(Util.backReference(tXText.getData(), this.encoding));
    }

    public void visitDTDPre(DTD dTD) throws Exception {
        this.writer.write("<!DOCTYPE " + dTD.getName());
        if (dTD.getExternalID() != null) {
            this.writer.write(" " + dTD.getExternalID());
        }
        if (dTD.isPrintInternalDTD() && dTD.getInternalSize() > 0) {
            this.writer.write(" [");
            return;
        }
        throw new ToNextSiblingTraversalException();
    }

    public void visitDTDPost(DTD dTD) throws Exception {
        if (dTD.isPrintInternalDTD() && dTD.getInternalSize() > 0) {
            this.writer.write("]");
        }
        this.writer.write(">");
    }

    public void visitElementDeclPre(ElementDecl elementDecl) throws Exception {
        this.writer.write("<!ELEMENT " + elementDecl.getName() + " " + elementDecl.getXML4JContentModel() + ">");
    }

    public void visitAttlistPre(Attlist attlist) throws Exception {
        this.writer.write("<!ATTLIST " + attlist.getName());
        int n = attlist.size();
        if (n <= 0) {
            this.writer.write(" >");
            return;
        }
        if (n == 1) {
            this.visitAttDefPre(attlist.elementAt(0));
            this.writer.write(62);
            return;
        }
        this.writer.write("\n");
        int n2 = 0;
        while (n2 < n) {
            Util.printSpace(this.writer, 4);
            this.visitAttDefPre(attlist.elementAt(n2));
            if (n2 == n - 1) {
                this.writer.write(">");
            } else {
                this.writer.write("\n");
            }
            ++n2;
        }
    }

    public void visitAttDefPre(AttDef attDef) throws Exception {
        int n;
        this.writer.write(String.valueOf(' ') + attDef.getName() + ' ');
        int n2 = attDef.getDeclaredType();
        if (n2 != 10) {
            this.writer.write(String.valueOf(AttDef.S_TYPESTR[attDef.getDeclaredType()]) + ' ');
        }
        if (n2 == 9 || n2 == 10) {
            this.writer.write(String.valueOf('(') + attDef.elementAt(0));
            n = 1;
            while (n < attDef.size()) {
                this.writer.write(String.valueOf('|') + attDef.elementAt(n));
                ++n;
            }
            this.writer.write(") ");
        }
        if ((n = attDef.getDefaultType()) == 2) {
            this.writer.write("#REQUIRED");
            return;
        }
        if (n == 3) {
            this.writer.write("#IMPLIED");
            return;
        }
        if (n == 1) {
            this.writer.write("#FIXED \"");
            this.writer.write(attDef.getDefaultStringValue() == null ? "(null)" : Util.backReferenceForEntity(attDef.getDefaultStringValue(), this.encoding));
            this.writer.write(34);
            return;
        }
        if (n == -1) {
            this.writer.write(34);
            this.writer.write(attDef.getDefaultStringValue() == null ? "(null)" : Util.backReferenceForEntity(attDef.getDefaultStringValue(), this.encoding));
            this.writer.write(34);
        }
    }

    public void visitEntityDeclPre(EntityDecl entityDecl) throws Exception {
        this.writer.write("<!ENTITY ");
        if (entityDecl.isParameter()) {
            this.writer.write("% ");
        }
        this.writer.write(String.valueOf(entityDecl.getNodeName()) + " ");
        if (entityDecl.getValue() != null) {
            this.writer.write("\"" + Util.backReferenceForEntity(entityDecl.getValue(), this.encoding) + "\">");
        } else {
            this.writer.write(entityDecl.getExternalID().toString());
            if (entityDecl.getNotationName() != null) {
                this.writer.write(" NDATA " + entityDecl.getNotationName());
            }
            this.writer.write(">");
        }
        throw new ToNextSiblingTraversalException();
    }

    public void visitNotationPre(TXNotation tXNotation) throws Exception {
        this.writer.write("<!NOTATION " + tXNotation.getNodeName() + " " + tXNotation.getExternalID() + ">");
    }

    public void visitGeneralReferencePre(GeneralReference generalReference) throws Exception {
        this.writer.write(String.valueOf('&') + generalReference.getName() + ';');
        throw new ToNextSiblingTraversalException();
    }

    public void visitPseudoNodePre(PseudoNode pseudoNode) throws Exception {
        this.writer.write(pseudoNode.getData());
    }
}

